<?php
require_once(__DIR__ . '/../config.php');
require_login();

global $DB, $USER, $CFG;

// Set up page
$context = context_system::instance();
$PAGE->set_context($context);
$PAGE->set_url(new moodle_url('/course/waws_report.php'));
$PAGE->set_title('AWS Course Report');
$PAGE->set_heading('AWS Course Report');
$PAGE->set_pagelayout('report');

echo $OUTPUT->header();
echo $OUTPUT->heading('AWS Course Report');

// Check if current user is an admin/manager
$is_admin = has_capability('moodle/site:config', $context);

// Fetch courses based on role
if ($is_admin) {
    // Admin → See ALL courses (Removed AWS filter)
    $courses = $DB->get_records_sql("
        SELECT id, fullname
        FROM {course}
        WHERE id <> 1
        ORDER BY fullname ASC
    ");
} else {
    // Normal user → See only courses they are enrolled in
    $courses = $DB->get_records_sql("
        SELECT c.id, c.fullname
        FROM {course} c
        JOIN {enrol} e ON e.courseid = c.id
        JOIN {user_enrolments} ue ON ue.enrolid = e.id
        WHERE ue.userid = ?
        ORDER BY c.fullname ASC
    ", [$USER->id]);
}

echo '<div class="table-responsive">';
echo '<table id="courseReportTable" class="table table-striped table-bordered">';
echo '<thead>
        <tr>
            <th>S.No</th>
            <th>Course Name</th>
            <th>Enrollments</th>
            <th>Course Started</th>
            <th>In-Progress</th>
            <th>Completed</th>
        </tr>
      </thead>
      <tbody>';

if (!empty($courses)) {
    $count = 1;
    foreach ($courses as $course) {
        // Count enrolled users
        $enrolled = $DB->count_records_sql("
            SELECT COUNT(ue.id)
            FROM {user_enrolments} ue
            JOIN {enrol} e ON ue.enrolid = e.id
            WHERE e.courseid = ?
        ", [$course->id]);

        // Fetch completion data for users enrolled in this course
        $completion_data = $DB->get_records_sql("
            SELECT cc.userid, cc.timecompleted
            FROM {course_completions} cc
            WHERE cc.course = ?
        ", [$course->id]);

        $started = 0;
        $inprogress = 0;
        $completed = 0;

        foreach ($completion_data as $comp) {
            if (!empty($comp->timecompleted)) {
                $completed++;
            } else {
                // Check if the user has started any activity in this course
                $progress = $DB->get_record_sql("
                    SELECT COUNT(*) AS done
                    FROM {course_modules_completion} cmc
                    JOIN {course_modules} cm ON cm.id = cmc.coursemoduleid
                    WHERE cm.course = ? AND cmc.userid = ? AND cmc.completionstate > 0
                ", [$course->id, $comp->userid]);

                if ($progress && $progress->done > 0) {
                    $inprogress++;
                } else {
                    $started++;
                }
            }
        }

        echo '<tr>';
        echo '<td>' . $count++ . '</td>';
        echo '<td><a href="'.$CFG->wwwroot.'/course/view.php?id='.$course->id.'" target="_blank">'.format_string($course->fullname).'</a></td>';
        echo '<td>' . $enrolled . '</td>';
        echo '<td>' . $started . '</td>';
        echo '<td>' . $inprogress . '</td>';
        echo '<td>' . $completed . '</td>';
        echo '</tr>';
    }
} else {
    echo '<tr><td colspan="6" class="text-center">No courses found.</td></tr>';
}

echo '</tbody></table></div>';
?>

<!-- DataTables & Bootstrap -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script>
$(document).ready(function() {
    $('#courseReportTable').DataTable({
        "responsive": true,
        "pageLength": 10,
        "order": [[1, "asc"]],
        "language": {
            "search": "Search Course:",
            "lengthMenu": "Show _MENU_ entries",
            "info": "Showing _START_ to _END_ of _TOTAL_ courses"
        }
    });
});
</script>

<?php
echo $OUTPUT->footer();
?>
