<?php
require_once(__DIR__ . '/../../config.php');
require_login();

$context = context_system::instance();
$PAGE->set_context($context);
$PAGE->set_url(new moodle_url('/local/custompage/index.php'));
$PAGE->set_title('Class Manager');
$PAGE->set_heading('Class Manager');
$PAGE->set_pagelayout('standard');

// ✅ Add Manager Button
$addmanagerurl = new moodle_url('/user/editadvanced.php', ['id' => -1]);
$addbutton = html_writer::link(
    $addmanagerurl,
    html_writer::tag('button', ' Add Class Manager', [
        'class' => 'btn btn-primary',
        'style' => 'margin-bottom: 15px;'
    ])
);

// Fetch all users who have Manager role
$sql = "SELECT u.id, u.firstname, u.lastname, u.email, u.timecreated
        FROM {user} u
        JOIN {role_assignments} ra ON ra.userid = u.id
        JOIN {role} r ON r.id = ra.roleid
        WHERE r.shortname = :rolename
        ORDER BY u.timecreated DESC";
$managers = $DB->get_records_sql($sql, ['rolename' => 'manager']);

echo $OUTPUT->header();
echo html_writer::tag('h2', 'Class Manager', ['class' => 'mb-3']);
echo $addbutton;

if (empty($managers)) {
    echo $OUTPUT->notification('No managers found in the system.', 'notifymessage');
    echo $OUTPUT->footer();
    exit;
}

// ✅ Build Table
$table = new html_table();
$table->id = 'managers-table';
$table->head = ['S.No', 'Name', 'Email', 'Created On', 'Action'];
$table->attributes['class'] = 'generaltable table table-striped';

$counter = 1;
foreach ($managers as $user) {
    $fullname = fullname($user);
    $email = $user->email;
    $createdon = userdate($user->timecreated, get_string('strftimedate', 'langconfig'));

    // ✅ URLs for actions
    $viewurl = new moodle_url('/local/custompage/viewmanager.php', ['id' => $user->id]);
    $editurl = new moodle_url('/user/editadvanced.php', ['id' => $user->id]);
$viewicon = html_writer::link(
    $viewurl,
    html_writer::tag('i', '', array('class' => 'fa fa-eye fa-fw')),
    array('title' => 'View Manager', 'class' => 'action-icon')
);

    $editicon = $OUTPUT->action_icon($editurl, new pix_icon('t/edit', 'Edit'));

    $actions = $viewicon . " " . $editicon;

    $table->data[] = [
        $counter++,
        $fullname,
        $email,
        $createdon,
        $actions
    ];
}

echo html_writer::table($table);
?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>

<script>
document.addEventListener("DOMContentLoaded", function () {
    $('#managers-table').DataTable({
        "pageLength": 10,
        "lengthMenu": [5, 10, 25, 50, 100],
        "order": [],
        "language": {
            "search": "Search:",
            "lengthMenu": "Show _MENU_ entries per page"
        }
    });
});
</script>
<?php
echo $OUTPUT->footer();
?>
