<?php
require_once(__DIR__ . '/../config.php');
require_login();

global $DB, $USER, $CFG;

// Set up page
$context = context_system::instance();
$PAGE->set_context($context);
$PAGE->set_url(new moodle_url('/course/waws_report.php'));
$PAGE->set_title('AWS Course Report');
$PAGE->set_heading('AWS Course Report');
$PAGE->set_pagelayout('report');

echo $OUTPUT->header();
echo $OUTPUT->heading('AWS Course Report');

// Fetch courses for the current user
$courses = $DB->get_records_sql("
    SELECT c.id, c.fullname
    FROM {course} c
    JOIN {enrol} e ON e.courseid = c.id
    JOIN {user_enrolments} ue ON ue.enrolid = e.id
    WHERE ue.userid = ?
    ORDER BY c.fullname ASC
", [$USER->id]);

echo '<div class="table-responsive">';
echo '<table id="courseReportTable" class="table table-striped table-bordered">';
echo '<thead>
        <tr>
            <th>S.No</th>
            <th>Course Name</th>
            <th>Started</th>
            <th>In-Progress</th>
            <th>Completed</th>
        </tr>
      </thead>
      <tbody>';

if (!empty($courses)) {
    $count = 1;
    foreach ($courses as $course) {
        // Count directly from mdl_local_ltiprogress for this user
        $started = $DB->count_records('local_ltiprogress', [
            'ltiid' => $course->id,
            'userid' => $USER->id,
            'activityprogress' => 'Started'
        ]);

        $inprogress = $DB->count_records('local_ltiprogress', [
            'ltiid' => $course->id,
            'userid' => $USER->id,
            'activityprogress' => 'InProgress'
        ]);

        $completed = $DB->count_records('local_ltiprogress', [
            'ltiid' => $course->id,
            'userid' => $USER->id,
            'activityprogress' => 'Completed'
        ]);

        echo '<tr>';
        echo '<td>' . $count++ . '</td>';
        echo '<td>'.format_string($course->fullname).'</a></td>';
        echo '<td>' . $started . '</td>';
        echo '<td>' . $inprogress . '</td>';
        echo '<td>' . $completed . '</td>';
        echo '</tr>';
    }
} else {
    echo '<tr><td colspan="5" class="text-center">No courses found.</td></tr>';
}

echo '</tbody></table></div>';
?>

<!-- DataTables & Bootstrap -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script>
$(document).ready(function() {
    $('#courseReportTable').DataTable({
        "responsive": true,
        "pageLength": 10,
        "order": [[1, "asc"]],
        "language": {
            "search": "Search Course:",
            "lengthMenu": "Show _MENU_ entries",
            "info": "Showing _START_ to _END_ of _TOTAL_ courses"
        }
    });
});
</script>

<?php
echo $OUTPUT->footer();
?>
