<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'repository_dropbox', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package   repository_dropbox
 * @copyright 2010 Dongsheng Cai
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['configplugin'] = 'Dropbox configuration';
$string['crontask'] = 'Background processing for Dropbox repository';
$string['notitle'] = 'notitle';
$string['remember'] = 'Remember me';
$string['pluginname'] = 'Dropbox';
$string['dropbox'] = 'Dropbox';
$string['issuer'] = 'OAuth 2 service';
$string['issuer_help'] = 'Select the OAuth 2 service that is configured to talk to the Dropbox API. If the service doesn\'t exist yet, you will need to create it.';
$string['cachelimit'] = 'Cache limit';
$string['cachelimit_info'] = 'Enter the maximum size of files (in bytes) to be cached on server for Dropbox aliases/shortcuts. Cached files will be served when the source is no longer available. Empty value or zero mean caching of all files regardless of size.';
$string['dropbox:view'] = 'View a Dropbox folder';
$string['logoutdesc'] = '(Logout when you finish using Dropbox)';
$string['oauth2redirecturi'] = 'OAuth 2 Redirect URI';
$string['privacy:metadata:repository_dropbox'] = 'The Dropbox repository plugin does not store any personal data, but does transmit user data from Moodle to the remote system.';
$string['privacy:metadata:repository_dropbox:query'] = 'The Dropbox repository user search text query.';

// Deprecated since Moodle 4.0.
$string['apikey'] = 'Dropbox API key';
$string['secret'] = 'Dropbox secret';
$string['instruction'] = 'You can get your API Key and secret from <a href="https://www.dropbox.com/developers/apps">Dropbox developers</a>. When setting up your key please select "Full Dropbox" as the "Access level".';