define("core/emoji/auto_complete",["exports","core/emoji/data","core/templates","core/utils","core/localstorage","core/key_codes"],(function(_exports,EmojiData,_templates,_utils,_localstorage,_key_codes){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,EmojiData=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}
/**
   * Emoji auto complete.
   *
   * @module core/emoji/auto_complete
   * @copyright  2019 Ryan Wyllie <ryan@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */(EmojiData),_localstorage=_interopRequireDefault(_localstorage),_key_codes=_interopRequireDefault(_key_codes);const SELECTORS_EMOJI_BUTTON='[data-region="emoji-button"]',SELECTORS_ACTIVE_EMOJI_BUTTON='[data-region="emoji-button"].active',getRecentEmojis=()=>{const storedData=_localstorage.default.get("moodle-recent-emojis");return storedData?JSON.parse(storedData):[]},addRecentEmoji=(unified,shortName)=>{const newEmoji={unified:unified,shortnames:[shortName]},recentEmojis=getRecentEmojis();let newRecentEmojis=[newEmoji,...recentEmojis.filter((emoji=>emoji.unified!=newEmoji.unified))];newRecentEmojis=newRecentEmojis.slice(0,27),_localstorage.default.set("moodle-recent-emojis",JSON.stringify(newRecentEmojis))},getEmojiTextFromShortName=shortName=>{const unified=EmojiData.byShortName[shortName];if(unified){const charCodes=unified.split("-").map((code=>"0x".concat(code)));return String.fromCodePoint.apply(null,charCodes)}return null},getShortNameFromText=text=>text.replace(/:/g,""),getActiveEmojiSuggestion=root=>root.querySelector(SELECTORS_ACTIVE_EMOJI_BUTTON),selectEmojiElement=(element,selectCallback)=>{const shortName=element.getAttribute("data-short-name"),unified=element.getAttribute("data-unified");addRecentEmoji(unified,shortName),selectCallback(element.innerHTML.trim())};return _exports.default=(root,textArea,hasSuggestionCallback,selectCallback)=>{let hasSuggestions=!1,previousSearchText="";textArea.addEventListener("keyup",(0,_utils.debounce)((()=>{const searchText=((text,position)=>{const startMatches=text.slice(0,position).match(/(\S*)$/),endMatches=text.slice(position).match(/^(\S*)/);let startText="",endText="";return startMatches&&(startText=startMatches[startMatches.length-1]),endMatches&&(endText=endMatches[endMatches.length-1]),"".concat(startText).concat(endText)})(textArea.value,textArea.selectionStart);if(searchText!==previousSearchText){if(previousSearchText=searchText,(text=>/^:[^:\s]+:$/.test(text))(searchText)){const shortName=getShortNameFromText(searchText),emojiText=getEmojiTextFromShortName(shortName);hasSuggestions=!1,emojiText&&(addRecentEmoji(EmojiData.byShortName[shortName],shortName),selectCallback(emojiText))}else if((text=>/^:[^:\s]*$/.test(text))(searchText)){const suggestions=(searchTerm=getShortNameFromText(searchText),limit=50,""===searchTerm?getRecentEmojis().map((data=>data.shortnames[0])).slice(0,limit):(searchTerm=searchTerm.toLowerCase(),Object.keys(EmojiData.byShortName).filter((shortName=>shortName.includes(searchTerm))).slice(0,limit)));suggestions.length?((async(root,shortNames)=>{const renderContext={emojis:shortNames.map(((shortName,index)=>({active:0===index,emojitext:getEmojiTextFromShortName(shortName),displayshortname:":".concat(shortName,":"),shortname:shortName,unified:EmojiData.byShortName[shortName]})))},html=await(0,_templates.render)("core/emoji/auto_complete",renderContext);root.innerHTML=html})(root,suggestions),hasSuggestions=!0):hasSuggestions=!1}else hasSuggestions=!1;var searchTerm,limit;hasSuggestionCallback(hasSuggestions)}}),200)),textArea.addEventListener("keydown",(e=>{if(hasSuggestions){if(!(e.shiftKey||e.metaKey||e.altKey||e.ctrlKey))switch(e.which){case _key_codes.default.escape:hasSuggestions=!1,hasSuggestionCallback(!1);break;case _key_codes.default.arrowLeft:(root=>{const activeEmojiSuggestion=getActiveEmojiSuggestion(root),previousSuggestion=activeEmojiSuggestion.previousElementSibling;previousSuggestion&&(activeEmojiSuggestion.classList.remove("active"),previousSuggestion.classList.add("active"),previousSuggestion.scrollIntoView({behaviour:"smooth",inline:"center"}))})(root),e.preventDefault();break;case _key_codes.default.arrowRight:(root=>{const activeEmojiSuggestion=getActiveEmojiSuggestion(root),nextSuggestion=activeEmojiSuggestion.nextElementSibling;nextSuggestion&&(activeEmojiSuggestion.classList.remove("active"),nextSuggestion.classList.add("active"),nextSuggestion.scrollIntoView({behaviour:"smooth",inline:"center"}))})(root),e.preventDefault();break;case _key_codes.default.enter:selectEmojiElement(getActiveEmojiSuggestion(root),selectCallback),e.preventDefault(),e.stopPropagation()}}})),root.addEventListener("click",(e=>{const target=e.target;target.matches(SELECTORS_EMOJI_BUTTON)&&selectEmojiElement(target,selectCallback)}))},_exports.default}));

//# sourceMappingURL=auto_complete.min.js.map