<?php
require_once(__DIR__ . '/../../config.php');
require_login();

global $DB, $PAGE, $OUTPUT, $USER;

$context = context_system::instance();
$PAGE->set_url('/local/learningpath/learner_paths.php');
$PAGE->set_context($context);
$PAGE->set_title("Learning Paths");
$PAGE->set_heading("Learning Paths");

// Pagination
$perpage = 10;
$page    = optional_param('page', 0, PARAM_INT);
$start   = $page * $perpage;

// Fetch learning paths
$paths = $DB->get_records('learning_paths', null, 'id DESC', '*', $start, $perpage);
$total = $DB->count_records('learning_paths');

echo $OUTPUT->header();
?>

<style>
/* Container */
.container { max-width:1100px; margin:20px auto; }

/* Header */
.lp-header { display:flex; justify-content:space-between; align-items:center; margin-bottom:20px; }
.lp-title-main { font-size:22px; font-weight:600; }

/* Search */
#lpSearch { padding:6px 10px; border-radius:6px; border:1px solid #d7e0ef; width:220px; }

/* List wrapper */
.lp-list { background:#fff; padding:0px; border-radius:0px; }

/* Learning Path Row – List view */
.lp-item {
    background:#fff;
    padding:10px 12px;
    border-bottom:1px solid #e3e7ef;
    margin:0;
}

/* LP Name */
.lp-name { font-size:16px; font-weight:600; }

/* Progress bar */
.lp-progress {
    width:220px;
    height:6px;
    background:#eef2ff;
    border-radius:4px;
    overflow:hidden;
    margin-top:6px;
}
.lp-progress-fill {
    height:6px;
    background:#4a8efc;
}

/* Access button */
.access-btn {
    background:#1677ff;
    color:#fff;
    padding:5px 12px;
    border-radius:4px;
    text-decoration:none;
    font-size:13px;
}

/* Toggle arrow — smaller */
.toggle-btn {
    background:transparent;
    border:none;
    cursor:pointer;
    font-size:12px;
    color:#333;
    padding:2px 4px;
}

/* Section + Courses */
.section-item { margin:6px 0; display:flex; align-items:center; gap:6px; }
.section-title { font-weight:600; font-size:14px; }

.course-item { margin:2px 0 2px 22px; font-size:13px; }
</style>

<div class="container">

    <div class="lp-header">
        <div class="lp-title-main">Available Learning Paths</div>
        <input type="search" id="lpSearch" placeholder="Search learning paths">
    </div>

    <div class="lp-list" id="lpList">

        <?php if (empty($paths)): ?>
            <div style="padding:20px">No learning paths found.</div>

        <?php else: ?>
            <?php foreach ($paths as $lp): ?>

                <?php
                // Progress calculation
                $completed = $DB->count_records_sql("
                    SELECT COUNT(*)
                    FROM {learning_path_courses} c
                    JOIN {course_completions} cc 
                        ON cc.course = c.courseid AND cc.userid = ?
                    WHERE c.sectionid IN (
                        SELECT id FROM {learning_path_sections} WHERE learningpathid = ?
                    ) AND cc.timecompleted IS NOT NULL
                ", [$USER->id, $lp->id]);

                $totalcourses = $DB->count_records_sql("
                    SELECT COUNT(*) FROM {learning_path_courses}
                    WHERE sectionid IN (
                        SELECT id FROM {learning_path_sections}
                        WHERE learningpathid = ?
                    )
                ", [$lp->id]);

                $progress = ($totalcourses > 0) ? round(($completed / $totalcourses) * 100) : 0;
                ?>

                <div class="lp-item">

                    <!-- Top Row: Name | Progress | Access Button | Arrow -->
                    <div style="display:flex; justify-content:space-between; align-items:center;">

                        <div>
                            <div class="lp-name"><?= format_string($lp->name) ?></div>
                            <div class="lp-progress">
                                <div class="lp-progress-fill" style="width:<?= $progress ?>%"></div>
                            </div>
                        </div>

                        <div style="display:flex; align-items:center; gap:10px;">
                            <a href="learner_path_view.php?id=<?= $lp->id ?>" class="access-btn">Access Now</a>

                            <!-- Right side arrow -->
                            <button class="toggle-btn"
                                onclick="toggleSections(<?= $lp->id ?>)"
                                id="btn-lp-<?= $lp->id ?>">▶</button>
                        </div>

                    </div>

                    <!-- Expandable Sections -->
                    <div id="sections-<?= $lp->id ?>" style="display:none; margin-top:6px; margin-left:8px;">

                        <?php
                        $sections = $DB->get_records('learning_path_sections', ['learningpathid' => $lp->id], 'id ASC');

                        if (empty($sections)): ?>
                            <div class="small">No sections available.</div>

                        <?php else: ?>
                            <?php foreach ($sections as $sec): ?>

                                <div class="section-item">
                                    <button class="toggle-btn" onclick="toggleCourses(<?= $sec->id ?>)" id="btn-sec-<?= $sec->id ?>">▶</button>
                                    <span class="section-title"><?= format_string($sec->sectionname) ?></span>
                                </div>

                                <!-- Courses -->
                                <div id="courses-<?= $sec->id ?>" style="display:none;">

                                    <?php
                                    $courses = $DB->get_records('learning_path_courses', ['sectionid' => $sec->id]);
                                    if (empty($courses)): ?>
                                        <div class="small">No courses in this section.</div>
                                    <?php else: ?>
                                        <?php foreach ($courses as $c):
                                            $course = $DB->get_record('course', ['id' => $c->courseid]);
                                            if ($course): ?>
                                                <div class="course-item">• <?= format_string($course->fullname) ?></div>
                                            <?php endif;
                                        endforeach; ?>
                                    <?php endif; ?>

                                </div>

                            <?php endforeach; ?>
                        <?php endif; ?>

                    </div>

                </div>

            <?php endforeach; ?>
        <?php endif; ?>

    </div>

    <!-- Pagination -->
    <div style="margin-top:16px;">
        <?php
            $baseurl = new moodle_url('/local/learningpath/learner_paths.php');
            echo $OUTPUT->paging_bar($total, $page, $perpage, $baseurl);
        ?>
    </div>

</div>

<script>
function toggleSections(id) {
    let div = document.getElementById("sections-" + id);
    let btn = document.getElementById("btn-lp-" + id);

    if (div.style.display === "none") {
        div.style.display = "block";
        btn.innerHTML = "▼";
    } else {
        div.style.display = "none";
        btn.innerHTML = "▶";
    }
}

function toggleCourses(id) {
    let div = document.getElementById("courses-" + id);
    let btn = document.getElementById("btn-sec-" + id);

    if (div.style.display === "none") {
        div.style.display = "block";
        btn.innerHTML = "▼";
    } else {
        div.style.display = "none";
        btn.innerHTML = "▶";
    }
}
</script>

<?php echo $OUTPUT->footer(); ?>
