console.log("Learning Path JS loaded ✅");

$(document).ready(function () {
  console.log("Learning Path script initialized ✅");

  const $courseSelect = $('#activityCourseSelect');
  const $categorySelect = $('#categorySelect');
  const $languageSelect = $('#activityLanguageFilter');   // ✅ NEW
  const $modal = $('#activityModal');
  const isEditForm = $('#lpEditForm').length > 0;
  const $form = isEditForm ? $('#lpEditForm') : $('#lpCreateForm');

  // ---------- 1️⃣ PRELOAD ALL COURSES ----------
  function preloadAllCourses() {
    $.ajax({
      url: window.lp_config.ajaxCoursesUrl,
      type: 'GET',
      data: {
        term: '',
        category: $categorySelect.val() || 0,
        language: $languageSelect.val() || '',   // ✅ NEW
        sesskey: window.lp_config.sesskey
      },
      success: function (data) {
        const options = data.map(function (item) {
          return new Option(item.fullname, item.id, false, false);
        });

        $courseSelect.html(''); 
        options.forEach(opt => $courseSelect.append(opt));

        $courseSelect.trigger('change');
      }
    });
  }

  preloadAllCourses();

  // ---------- 2️⃣ INITIALIZE SELECT2 ----------
  if ($.fn.select2) {
    $courseSelect.select2({
      placeholder: 'Search and select courses...',
      width: '100%',
      multiple: true,
      minimumInputLength: 0,

      ajax: {
        url: window.lp_config.ajaxCoursesUrl,
        dataType: 'json',
        delay: 300,
        data: function (params) {
          return {
            term: params.term || '',
            category: $categorySelect.val() || 0,
            language: $languageSelect.val() || '',   // ✅ send language filter
            sesskey: window.lp_config.sesskey
          };
        },
        processResults: function (data) {
          return {
            results: data.map(function (item) {
              return { id: item.id, text: item.fullname };
            })
          };
        },
        cache: true
      }
    });
  } else {
    console.error("Select2 not loaded!");
  }


  // ---------- 3️⃣ RELOAD WHEN LANGUAGE CHANGES ----------
  $languageSelect.on('change', function () {
    console.log("Language filter changed → reload courses");

    $courseSelect.val(null).trigger('change');
    preloadAllCourses();  // reload based on language
  });

  // ---------- 4️⃣ RELOAD WHEN CATEGORY CHANGES ----------
  $categorySelect.on('change', function () {
    console.log("Category changed → reload courses");

    $courseSelect.val(null).trigger('change');
    preloadAllCourses();
  });


  // ---------- SECTIONS MODULE ----------
  $('#addSectionBtn').on('click', function () {
    const sectionCount = $('#sectionsContainer .section-item').length + 1;

    $('#sectionsContainer').append(`
      <div class="section-item p-3 mb-3">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <div>
            <i class="fa fa-bars drag-handle"></i>
            <strong contenteditable="true" class="section-title">New Section ${sectionCount}</strong>
          </div>
          <div>
            <button type="button" class="btn btn-xs btn-outline-primary add-activity">+ Add Activity</button>
            <button type="button" class="btn btn-xs btn-outline-danger remove-section">&times;</button>
          </div>
        </div>
        <ul class="list-group course-list mb-2"></ul>
      </div>
    `);
  });

  $(document).on('click', '.remove-section', function () {
    $(this).closest('.section-item').remove();
  });


  // ---------- OPEN MODAL ----------
  $(document).on('click', '.add-activity', function () {
    const categoryId = $categorySelect.val();
    if (!categoryId) {
      alert('Please select a category first.');
      return;
    }

    window.activeSection = $(this).closest('.section-item').find('.course-list');
    $modal.modal('show');
  });

  $modal.on('hidden.bs.modal', function () {
    $courseSelect.val(null).trigger('change');
  });


  // ---------- ADD COURSES ----------
  $('#activityAddBtn').on('click', function () {
    const selectedCourses = $courseSelect.select2('data');

    if (!selectedCourses.length) {
      alert('Please select at least one course.');
      return;
    }

    const list = window.activeSection || $('.section-item').last().find('.course-list');

    selectedCourses.forEach(function (course) {
      if (list.find(`[data-course-id="${course.id}"]`).length === 0) {
        list.append(`
          <li class="list-group-item list-course-item draggable-course d-flex justify-content-between align-items-center" data-course-id="${course.id}">
            <span><i class="fa fa-grip-lines drag-handle me-2"></i>${course.text}</span>
            <span>
              <a href="${M.cfg.wwwroot}/course/view.php?id=${course.id}" target="_blank" class="me-2 small">Open</a>
              <button type="button" class="btn btn-sm btn-outline-danger remove-course">&times;</button>
            </span>
          </li>
        `);
      }
    });

    $courseSelect.val(null).trigger('change');
    $modal.modal('hide');
  });

  $(document).on('click', '.remove-course', function () {
    $(this).closest('li').remove();
  });


  // ---------- SORTABLE ----------
  if (typeof Sortable !== 'undefined') {
    new Sortable(document.getElementById('sectionsContainer'), {
      handle: '.drag-handle',
      animation: 150
    });

    $('#sectionsContainer .course-list').each(function () {
      new Sortable(this, {
        handle: '.drag-handle',
        animation: 150
      });
    });
  }


  // ---------- SAVE STRUCTURE ----------
  $form.on('submit', function () {
    const structure = [];

    $('#sectionsContainer .section-item').each(function () {
      const sectionId = $(this).data('section-id') || null;
      const sectionTitle = $(this).find('.section-title').text().trim();
      const courses = [];

      $(this).find('.course-list li').each(function () {
        courses.push({
          id: $(this).data('course-id'),
          name: $(this).text().trim().replace('×', '').trim()
        });
      });

      structure.push({
        id: sectionId,
        title: sectionTitle,
        courses: courses
      });
    });

    $('#structure_json').val(JSON.stringify(structure));
  });
});
