<?php
require_once('../../config.php');
require_login();

global $DB, $PAGE, $OUTPUT, $USER;

// Page setup
$PAGE->set_url(new moodle_url('/local/custompage/my_requested_courses.php'));
$PAGE->set_context(context_system::instance());
$PAGE->set_title('My Enrolled Courses');
$PAGE->set_heading('My Enrolled Courses');

// Pagination parameters
$perpage = 10; // number of courses per page
$page = optional_param('page', 0, PARAM_INT);
$start = $page * $perpage;

// Count total enrolled courses
$countsql = "SELECT COUNT(1)
             FROM {course} c
             JOIN {enrol} e ON e.courseid = c.id
             JOIN {user_enrolments} ue ON ue.enrolid = e.id
             WHERE ue.userid = :userid";

$totalcourses = $DB->count_records_sql($countsql, ['userid' => $USER->id]);

// Fetch paginated enrolled courses
$sql = "SELECT c.id, c.fullname
        FROM {course} c
        JOIN {enrol} e ON e.courseid = c.id
        JOIN {user_enrolments} ue ON ue.enrolid = e.id
        WHERE ue.userid = :userid
        ORDER BY c.fullname ASC";

$courses = $DB->get_records_sql($sql, ['userid' => $USER->id], $start, $perpage);

echo $OUTPUT->header();
echo html_writer::tag('h2', 'My Enrolled Courses');

// Table setup
$table = new html_table();
$table->head = ['S.No', 'Course Name', 'Access'];
$table->attributes['class'] = 'generaltable'; // Moodle default style

$sn = $start + 1; // correct numbering for pagination

foreach ($courses as $course) {
    $courseurl = new moodle_url('/course/view.php', ['id' => $course->id]);

    // Access button
    $button = html_writer::link(
        $courseurl,
        'Access',
        ['class' => 'btn btn-primary']
    );

    $table->data[] = [
        $sn++,
        $course->fullname,
        $button
    ];
}

// If no courses, show message instead of empty table
if ($totalcourses == 0) {
    echo html_writer::div('No enrolled courses found.', 'alert alert-info');
} else {
    // Print table
    echo html_writer::table($table);

    // Pagination bar (Moodle default)
    $baseurl = new moodle_url('/local/custompage/my_requested_courses.php');
    echo $OUTPUT->paging_bar($totalcourses, $page, $perpage, $baseurl);
}

echo $OUTPUT->footer();
