<?php
require(__DIR__ . '/../../config.php');
require_once($CFG->dirroot . '/course/lib.php');

require_login();

// Only admins can access
if (!is_siteadmin()) {
    throw new moodle_exception('Access denied');
}

// Setup page
$PAGE->set_context(context_system::instance());
$PAGE->set_url(new moodle_url('/local/custompage/delete_course1.php'));
$PAGE->set_title('AWS Course Cleanup');
$PAGE->set_heading('AWS Course Cleanup Tool');

// AWS category
$categoryid = 7;

// FINAL ARRAY OF 101 SHORTNAMES TO DELETE
$todelete_shortnames = [
'14F7HPRWAF','24126DQMH9','2NFNJFDTWJ','2NZNHFDUTW','2RWY5646S3','345Y7DCKBB','35M79UVJ7Z',
'3Y74Z9T69C','3Z7B6SZ6RM','48S54ZC2NN','5JJGARKBJ7','5TF3EHV193','6HNSVT5DA4','76MDUZ258Y',
'7ADDKCW3JG','7BQXT67TWT','7JZ9RUZFY3','7RWAC2ZFV4','7TN87SUAMZ','861EVB3RCW','88W8RHK9CB',
'8YHSWJV84D','8YT61DF8CZ','93PUGT49EX','94BAW4XKYC','A61U7KGDFS','A8MMHRXE3E','A92JGWP8XS',
'AAEB1Q4SZU','ACDA','AH2Z4MANWB','AQF745TCTB','AZD56GD32X','B5ZWFBZACS','BFUV233J9G',
'BHFYC4RPAR','BHSQPHCW72','DCRH96KZB9','DQXRXX3882','EB5KQ6KUWF','ES2CBZMZMA','ETCNBWSJUX',
'FWKGXUUAG3','FZD2KC9TSX','G294ECSWT4','GCQXW8JMJ7','GZ1ECRKG7K','HMSVVTFCVK','HQK5P3TM7E',
'J5Z8ETDW2T','JM3Q5VPTK6','JPFP2JUHMF','K8TTM5P4FC','KBB8Q6HHQZ','KCP2Q16784','MDM8SNM8CM',
'MKR7KMA47F','N43NYRUEWC','N5UJZK9NR7','ND5DDHTDEA','NQVYXGH3HQ','PFRZQNAWDV','PJDFPYGGAH',
'PJR682AQW9','PSSY3MTDEZ','PUTTTM83DD','Q5439BN5MG','Q55KUW8GEQ','QNQSXXXR95','R1VX8QXD6T',
'RAD5ASYDUW','S9H9R83SFP','SC319HBZ59','SJ81VJ81CP','T1','TES','TES24','TGPF2PBZZZ','TJ6EF94DE8',
'TVE9JV2B9E','TWVS4CJVDW','U8RTMW9U2S','UCW21EXGC5','UK6MNJS791','V89JVR4TH3','VY75FAYYEY',
'W4UHCSE54Z','WRYYSANQ22','WXVK5Y995Y','WY5N1JGXDK','WZ2J6N4HG5','X4FJT7NGJB','XP4PTB16SV',
'XYWQGUWV2Y','XZH4KGETJJ','Y55FPYHBY8','YJUP2D8EKB','YWDQ2HPQHK','Z5C95J5K8B','lms','t244'
];


// PREVIEW MODE
if (!optional_param('delete', 0, PARAM_INT)) {

    echo $OUTPUT->header();
    echo "<h2>AWS Courses Marked for Deletion (Preview)</h2>";

    echo "<p>Total courses to delete: <strong>" . count($todelete_shortnames) . "</strong></p>";

    echo "<ul>";
    foreach ($todelete_shortnames as $sn) {
        echo "<li>$sn</li>";
    }
    echo "</ul>";

    echo "<form method='post'>
            <input type='hidden' name='delete' value='1'>
            <button style='padding:12px 25px;background:red;color:white;font-size:18px;
            border:none;border-radius:5px;cursor:pointer;'>
            DELETE ALL MISSING COURSES
            </button>
          </form>";

    echo $OUTPUT->footer();
    exit;
}

// DELETE MODE
echo $OUTPUT->header();
echo "<h2>Deleting AWS Courses...</h2>";

foreach ($todelete_shortnames as $sn) {

    // Find course by shortname + category 7
    if ($courseid = $DB->get_field('course', 'id', ['shortname' => $sn, 'category' => $categoryid])) {

        $course = get_course($courseid);

        echo "Deleting <strong>$sn</strong> (ID: $courseid)... ";

        // Moodle's full cascade delete
        delete_course($course);

        echo "<span style='color:green;'>OK</span><br>";
    }
}   

echo "<h3>All missing AWS courses deleted successfully.</h3>";
echo $OUTPUT->footer();
