<?php
require_once(__DIR__ . '/../../../../config.php');
require_login();

$PAGE->set_url(new moodle_url('/theme/academy/pages/awscatalog.php'));
$PAGE->set_context(context_system::instance());
$PAGE->set_pagelayout('standard');
$PAGE->set_title("AWS Course Catalog");
$PAGE->set_heading("AWS Course Catalog");

echo $OUTPUT->header();

global $DB;

// 🔹 Parameters for filters & pagination
$search     = optional_param('search', '', PARAM_TEXT);
$category   = optional_param('category', '', PARAM_TEXT);
$page       = optional_param('page', 0, PARAM_INT);
$perpage    = 10; // courses per page
$fieldid    = 5;  // replace with your AWS custom fieldid

// 🔹 Build SQL with filters
$where = "cf.fieldid = :fieldid";
$params = ['fieldid' => $fieldid];

if (!empty($search)) {
    $where .= " AND " . $DB->sql_like('c.fullname', ':search', false);
    $params['search'] = "%$search%";
}

if (!empty($category)) {
    $where .= " AND cat.name = :category";
    $params['category'] = $category;
}

$sql = "SELECT c.id, c.fullname, c.shortname, 
               cat.name AS categoryname,
               cf.data AS awslaunchurl
        FROM {course} c
        JOIN {course_categories} cat ON cat.id = c.category
        JOIN {customfield_data} cf ON cf.instanceid = c.id
        WHERE $where
        ORDER BY c.fullname ASC";

// 🔹 Total count for pagination
$countsql = "SELECT COUNT(1)
        FROM {course} c
        JOIN {course_categories} cat ON cat.id = c.category
        JOIN {customfield_data} cf ON cf.instanceid = c.id
        WHERE $where";

$totalcourses = $DB->count_records_sql($countsql, $params);

// 🔹 Fetch with limit
$courses = $DB->get_records_sql($sql, $params, $page * $perpage, $perpage);

// 🔹 Get categories for filter dropdown
$categories = $DB->get_records_menu('course_categories', null, 'name ASC', 'id, name');

// 🔹 Filter form
echo html_writer::start_tag('form', ['method' => 'get', 'class' => 'mb-3 form-inline']);
echo html_writer::empty_tag('input', [
    'type' => 'text',
    'name' => 'search',
    'value' => $search,
    'placeholder' => 'Search by course name',
    'class' => 'form-control mr-2'
]);

echo html_writer::select($categories, 'category', $category, ['' => 'All categories'], ['class' => 'form-control mr-2']);
echo html_writer::empty_tag('input', ['type' => 'submit', 'value' => 'Filter', 'class' => 'btn btn-secondary']);
echo html_writer::end_tag('form');

// 🔹 Table
$table = new html_table();
$table->head = ['Course Name', 'Category', 'Launch'];

foreach ($courses as $course) {
    $launchbtn = '';
    if (!empty($course->awslaunchurl)) {
        $launchbtn = html_writer::link(
            new moodle_url('/theme/academy/pages/launch.php', ['id' => $course->id]),
            'Launch',
            ['class' => 'btn btn-primary']
        );
    }

    $table->data[] = [
        format_string($course->fullname),
        format_string($course->categoryname),
        $launchbtn
    ];
}

echo html_writer::table($table);

// 🔹 Pagination bar
$baseurl = new moodle_url('/theme/academy/pages/awscatalog.php', [
    'search' => $search,
    'category' => $category
]);
echo $OUTPUT->paging_bar($totalcourses, $page, $perpage, $baseurl);

echo $OUTPUT->footer();
