<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Main login page.
 *
 * @package    core
 * @subpackage auth
 */

require('../config.php');
require_once('lib.php');

redirect_if_major_upgrade_required();

$testsession = optional_param('testsession', 0, PARAM_INT);
$anchor      = optional_param('anchor', '', PARAM_RAW);
$resendconfirmemail = optional_param('resendconfirmemail', false, PARAM_BOOL);

$context = context_system::instance();
$PAGE->set_url("$CFG->wwwroot/login/index.php");
$PAGE->set_context($context);
$PAGE->set_pagelayout('login');

$errormsg = '';
$errorcode = 0;

if ($testsession) {
    if ($testsession == $USER->id) {
        $urltogo = $SESSION->wantsurl ?? $CFG->wwwroot.'/';
        unset($SESSION->wantsurl);
        redirect($urltogo);
    } else {
        $errormsg = get_string("cookiesnotenabled");
        $errorcode = 1;
    }
}

$session_has_timed_out = !empty($SESSION->has_timed_out);
unset($SESSION->has_timed_out);

$frm  = false;
$user = false;

$authsequence = get_enabled_auth_plugins();
foreach($authsequence as $authname) {
    $authplugin = get_auth_plugin($authname);
    $authplugin->loginpage_hook();
}

$site = get_site();
$PAGE->navbar->ignore_active();
$loginsite = get_string("loginsite");
$PAGE->navbar->add($loginsite);

$frm = $frm ?: data_submitted();

// Handle login submission
if ($frm && isset($frm->username)) {
    $frm->username = trim(core_text::strtolower($frm->username));

    if (empty($errormsg)) {
        $logintoken = $frm->logintoken ?? '';
        $user = authenticate_user_login($frm->username, $frm->password, false, $errorcode, $logintoken);
    }

    if ($user) {
        complete_user_login($user);
        \core\session\manager::apply_concurrent_login_limit($user->id, session_id());

        if (empty($CFG->nolastloggedin) && !empty($CFG->rememberusername)) {
            set_moodle_cookie($USER->username);
        }

        $urltogo = core_login_get_return_url();
        $SESSION->wantsurl = $urltogo;
        redirect(new moodle_url(get_login_url(), array('testsession'=>$USER->id)));
    } else {
        $errormsg = $errormsg ?: get_string("invalidlogin");
        $errorcode = 3;
    }
}

if ($session_has_timed_out && !data_submitted()) {
    $errormsg = get_string('sessionerroruser', 'error');
    $errorcode = 4;
}

if (!isset($frm) or !is_object($frm)) {
    $frm = new stdClass();
}
$frm->username = $frm->username ?? get_moodle_cookie();
$frm->password = "";

$PAGE->set_title("$site->fullname: $loginsite");
$PAGE->set_heading("$site->fullname");

echo $OUTPUT->header();
?>
<style>
body.pagelayout-login {
   
    background-size: cover;
    overflow: hidden;
}
.header-main, #page-footer, .usermenu {
    display: none !important;
}
.login-wrapper {
    display: flex;
    justify-content: flex-end;
    align-items: center;
    height: 100vh;
    padding: 0 10%;
    padding-right: 0px;
}
.loginbox {
    background: rgba(255, 255, 255, 0.95);
    border-radius: 12px;
    padding: 27px;
    width: 414px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.2);
}
.loginbox h2 {
    text-align: center;
    font-size: 20px;
    font-weight: bold;
    margin-bottom: 20px;
}
.loginbox input[type="text"],
.loginbox input[type="password"] {
    border-radius: 6px;
    border: 1px solid #ddd;
    padding: 10px;
    width: 100%;
    margin-bottom: 15px;
    font-size: 14px;
}
.loginbox .btn-primary {
    background: #f56a2a;
    border: none;
    border-radius: 6px;
    padding: 10px;
    font-size: 15px;
    width: 100%;
}
.loginbox .btn-primary:hover {
    background: #e0591d;
}
.loginbox .forgetpass {
    display: block;
    text-align: center;
    margin-top: 12px;
}
</style>
<div class="login-wrapper">
    <div class="loginbox">
        <?php
        if (isloggedin() and !isguestuser()) {
            echo $OUTPUT->box_start();
            $logout = new single_button(new moodle_url('/login/logout.php',
                array('sesskey'=>sesskey(),'loginpage'=>1)), get_string('logout'), 'post');
            $continue = new single_button(new moodle_url('/'), get_string('cancel'), 'get');
            echo $OUTPUT->confirm(get_string('alreadyloggedin', 'error', fullname($USER)), $logout, $continue);
            echo $OUTPUT->box_end();
        } else {
            $loginform = new \core_auth\output\login($authsequence, $frm->username);
            $loginform->set_error($errormsg);
            echo $OUTPUT->render($loginform);
        }
        ?>
    </div>
</div>
<?php

$PAGE->requires->js_init_code("
    document.addEventListener('DOMContentLoaded', function() {
        // Hide header-main
        const headerMain = document.querySelector('.header-main');
        if (headerMain) {
            headerMain.style.display = 'none';
        }

        // Hide usermenu
        const userMenu = document.querySelector('.usermenu');
        if (userMenu) {
            userMenu.style.display = 'none';
        }

        // Hide all buttons with class 'btn btn-secondary'
        const secondaryButtons = document.querySelectorAll('.btn.btn-secondary');
        if (secondaryButtons.length > 0) {
            secondaryButtons.forEach(function(btn) {
                btn.style.display = 'none';
            });
        }

        // Set padding of login-wrapper to 0
        const loginWrapper = document.querySelector('.login-wrapper');
        if (loginWrapper) {
            loginWrapper.style.padding = '0';
        }

          // Set padding for #region-main
        const regionMain = document.querySelector('#region-main');
        if (regionMain) {
            regionMain.style.padding = '3px 40px';
        }

        // Make page non-scrollable
        document.body.style.overflow = 'hidden';
        document.documentElement.style.overflow = 'hidden';
    });
       document.addEventListener('DOMContentLoaded', function() {
        // Target .login-container
        const loginContainer = document.querySelector('.login-container');
        if (loginContainer) {
            loginContainer.style.boxShadow = 'none';
            loginContainer.style.background = 'none';
            loginContainer.style.backgroundColor = 'transparent';
        }

        // Target .loginbox
        const loginBox = document.querySelector('.loginbox');
        if (loginBox) {
            
            loginBox.style.background = 'none';
            loginBox.style.backgroundColor = 'transparent';
        }
    });

     document.addEventListener('DOMContentLoaded', function() {
        // Target .login-wrapper
        const loginWrapper = document.querySelector('.login-wrapper');
        if (loginWrapper) {
            loginWrapper.style.paddingRight = '0px';
        }
    });

    

");

echo '<script>
document.addEventListener("DOMContentLoaded", function() {
    // Get the header element
    const header = document.getElementById("header");

    if (header) {
        // Create a new div for the logo
        const logoDiv = document.createElement("div");
        logoDiv.style.width = "100%";
        logoDiv.style.textAlign = "center";
        logoDiv.style.position = "absolute";
        logoDiv.style.top = "0px";
        logoDiv.style.left = "0";
        logoDiv.style.zIndex = "1000";

        // Add the logo image
        const logoImg = document.createElement("img");
        logoImg.src = "'.$CFG->wwwroot.'/theme/academi/pix/logolms2-removebg-preview.png";
        logoImg.alt = "Site Logo";
        logoImg.style.maxHeight = "53px";
        logoImg.style.height = "auto";

        // Append image to div and div to header
        logoDiv.appendChild(logoImg);
        header.appendChild(logoDiv);
    }
});
</script>';

echo "<script>
document.addEventListener('DOMContentLoaded', function() {
    // Change heading text and color
    var heading = document.querySelector('h1.login-heading.mb-4');
    if (heading) {
        heading.textContent = 'Welcome To Trainocate';
        heading.style.color = 'white';
    }

    // Set white color for elements with login-form-forgotpassword and form-group
    var elements = document.querySelectorAll('.login-form-forgotpassword, .form-group');
    elements.forEach(function(el) {
        el.style.color = 'white';
        // Also set links inside them to white
        var links = el.querySelectorAll('a');
        links.forEach(function(link) {
            link.style.color = 'white';
        });
    });
});
</script>";

echo '<script>
document.addEventListener("DOMContentLoaded", function () {
    // Target the login input by its id
    var input = document.getElementById("username");
    if (input) {
        // Change placeholder text
        input.placeholder = "Email";

        // Change the label text
        var label = document.querySelector("label[for=\'username\']");
        if (label) {
            label.textContent = "Email";
        }
    }
});
</script>';

echo $OUTPUT->footer();


