<?php
require_once(__DIR__ . '/../../config.php');
require_login();
global $DB, $USER;

require_sesskey();
$context = context_system::instance();
require_capability('moodle/site:config', $context);

// --- Parameters ---
$id = required_param('id', PARAM_INT);
$categoryid = required_param('category_id', PARAM_INT);
$name = required_param('name', PARAM_TEXT);
$slug = optional_param('slug', '', PARAM_TEXT);
$sku = optional_param('sku', '', PARAM_TEXT);
$types = optional_param_array('type', [], PARAM_TEXT);
$level = optional_param('level', '', PARAM_TEXT);
$status = optional_param('status', 'Unpublish', PARAM_TEXT);
$structure_json = optional_param('structure_json', '', PARAM_RAW);

if (empty($name)) {
    print_error('invaliddata', 'error', '', 'Learning path name is required');
}

// --- Prepare main record ---
$record = new stdClass();
$record->categoryid = $categoryid;
$record->name = $name;
$record->slug = $slug;
$record->sku = $sku;
$record->type = implode(',', $types);
$record->level = $level;
$record->status = $status;
$record->timemodified = time();

if ($id === 0) {
    $record->timecreated = time();
    $record->createdby = $USER->id;
    $pathid = $DB->insert_record('learning_paths', $record);
} else {
    $record->id = $id;
    $DB->update_record('learning_paths', $record);
    $pathid = $id;
}

// --- Parse structure JSON ---
$data = json_decode($structure_json, true);
if (!is_array($data)) {
    $data = [];
}

// --- Fetch existing sections ---
$existing_sections = $DB->get_records('learning_path_sections', ['learningpathid' => $pathid]);
$existing_ids = array_keys($existing_sections);
$submitted_section_ids = [];

// --- Loop through submitted structure ---
foreach ($data as $sindex => $section) {
    $sectionid = isset($section['id']) && is_numeric($section['id']) ? (int)$section['id'] : 0;
    $sectionTitle = trim($section['title'] ?? ('Section ' . ($sindex + 1)));
    $position = $sindex + 1;

    $sec = new stdClass();
    $sec->learningpathid = $pathid;
    $sec->sectionname = $sectionTitle;
    $sec->position = $position;
    $sec->timemodified = time();

    if ($sectionid && isset($existing_sections[$sectionid])) {
        // --- Update existing section ---
        $sec->id = $sectionid;
        $DB->update_record('learning_path_sections', $sec);
    } else {
        // --- Insert new section ---
        $sectionid = $DB->insert_record('learning_path_sections', $sec);
    }

    $submitted_section_ids[] = $sectionid;

    // --- Replace courses in this section ---
    $DB->delete_records('learning_path_courses', ['sectionid' => $sectionid]);

    if (!empty($section['courses']) && is_array($section['courses'])) {
        $sort = 1;
        foreach ($section['courses'] as $course) {
            if (empty($course['id'])) continue;
            $c = new stdClass();
            $c->sectionid = $sectionid;
            $c->courseid = (int)$course['id'];
            $c->sortorder = $sort++;
            $c->timemodified = time();
            $DB->insert_record('learning_path_courses', $c);
        }
    }
}

// --- Delete removed sections ---
$to_delete = array_diff($existing_ids, $submitted_section_ids);
if (!empty($to_delete)) {
    list($in_sql, $params) = $DB->get_in_or_equal($to_delete);
    $DB->delete_records_select('learning_path_courses', "sectionid $in_sql", $params);
    $DB->delete_records_select('learning_path_sections', "id $in_sql", $params);
}

// --- Redirect after update ---
redirect(
    new moodle_url('/local/learningpath/manage.php'),
    'Learning Path updated successfully.',
    2
);
