<?php
require_once('../../config.php');
require_login();

$PAGE->set_url('/local/learningpath/admin_learningpath.php');
$PAGE->set_context(context_system::instance());
$PAGE->set_title('Admin Learning Paths');
$PAGE->set_heading('Admin Learning Paths');

echo $OUTPUT->header();

// ----------------------------
// Fetch Learning Paths
// ----------------------------
$lps = $DB->get_records('learning_paths') ?: [];

// Fetch LP sections + courses
$lp_courses = [];

foreach ($lps as $lp) {
    $lp_courses[$lp->id] = [];

    $sections = $DB->get_records('learning_path_sections', ['learningpathid' => $lp->id]);

    foreach ($sections as $section) {
        $courses = $DB->get_records('learning_path_courses', ['sectionid' => $section->id]);
        foreach ($courses as $c) {
            $lp_courses[$lp->id][] = $c;
        }
    }
}

// Load cohorts (batches)
$cohorts = $DB->get_records('cohort') ?: [];

?>
<style>
body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Arial; }
.card { border:1px solid #dce5f1; padding:15px; border-radius:10px; margin:12px 0; background:#fff; box-shadow:0 3px 8px rgba(0,0,0,0.05); }
.header { display:flex; justify-content:space-between; align-items:center; }
.small { color:#778; font-size:13px; }
.toggle-btn { background:#eef4ff; padding:4px 10px; border-radius:6px; border:1px solid #c7d7f5; cursor:pointer; }
.progress-bar { height:6px; background:#e9edf5; border-radius:4px; margin-top:8px; }
.progress-fill { height:6px; background:#4a8efc; width:0%; border-radius:4px; transition:0.3s; }
#assignModal {
    display:none; position:fixed; top:0; left:0; width:100%; height:100%;
    background:rgba(0,0,0,0.55); backdrop-filter: blur(3px);
}
.modal-box {
    width:420px; margin:120px auto; background:#fff; padding:20px;
    border-radius:10px; box-shadow:0 0 20px rgba(0,0,0,0.2);
}
</style>

<h2>Learning Path Assignment</h2>

<label><input type="checkbox" id="selectAll"> <strong>Select All</strong></label>

<form id="assignForm">

<?php if (empty($lps)) : ?>
    <div class="card"><strong>No learning paths found.</strong></div>

<?php else: ?>

    <?php foreach ($lps as $lp):
        $courses = $lp_courses[$lp->id] ?? [];
        $count = count($courses);
    ?>
        <div class="card">

            <div class="header">
                <div>
                    <input type="checkbox" class="lp-checkbox" name="lps[]" value="<?= $lp->id ?>">
                    <strong><?= format_string($lp->name) ?></strong>
                    <span class="small">(<?= $count ?> courses)</span>

                    <!-- Progress Bar Placeholder -->
                    <div class="progress-bar">
                        <div class="progress-fill" id="progress-<?= $lp->id ?>"></div>
                    </div>
                </div>

                <div class="toggle-btn" onclick="toggleLP(<?= $lp->id ?>)">Expand</div>
            </div>

            <div id="courses-<?= $lp->id ?>" style="display:none; margin-top:10px;">
                <?php if (empty($courses)) : ?>
                    <div class="small">No courses found.</div>
                <?php else: ?>
                    <?php foreach ($courses as $c):
                        $course = $DB->get_record('course', ['id' => $c->courseid]);
                    ?>
                        <div>
                            <input type="checkbox" class="course-checkbox" value="<?= $course->id ?>">
                            <?= format_string($course->fullname) ?>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>

        </div>
    <?php endforeach; ?>

<?php endif; ?>

<div style="margin-top:15px;">
    <label><strong>Select Batch</strong></label>
    <select name="batchid" required>
        <option value="">-- Select --</option>
        <?php foreach ($cohorts as $c):
            $cnt = $DB->count_records('cohort_members', ['cohortid' => $c->id]);
        ?>
            <option value="<?= $c->id ?>"><?= format_string($c->name) ?> (<?= $cnt ?> Users)</option>
        <?php endforeach; ?>
    </select>
</div>

<br>

<button type="button" onclick="openAssignModal()" class="btn btn-primary">Assign / Enrol</button>

</form>

<!-- Modal -->
<div id="assignModal">
    <div class="modal-box">
        <h3>Confirm Assignment</h3>
        <p>Do you want to assign selected learning paths to the selected batch?</p>

        <button onclick="submitAssign()" class="btn btn-success">Yes, Assign</button>
        <button onclick="closeAssignModal()" class="btn btn-secondary">Cancel</button>
    </div>
</div>

<script>
// Expand/Collapse Animation
function toggleLP(id) {
    let box = document.getElementById('courses-' + id);
    box.style.display = (box.style.display === 'none') ? 'block' : 'none';
}

// Select All
document.getElementById('selectAll').addEventListener('change', function() {
    let c = this.checked;
    document.querySelectorAll('.lp-checkbox, .course-checkbox').forEach(x => x.checked = c);
});

// Modal Open/Close
function openAssignModal() {
    document.getElementById('assignModal').style.display = 'block';
}
function closeAssignModal() {
    document.getElementById('assignModal').style.display = 'none';
}

// Submit Form
function submitAssign() {
    document.getElementById('assignForm').submit();
}
</script>

<?php
echo $OUTPUT->footer();
