<?php
require_once(__DIR__ . '/../../config.php');
require_login();
global $DB, $PAGE, $OUTPUT;

$courseid = required_param('course', PARAM_INT);
$batchid = optional_param('batch', 0, PARAM_INT);
$userids = optional_param('userids', '', PARAM_RAW);

$context = context_system::instance();
require_capability('moodle/role:assign', $context);

$PAGE->set_context($context);
$PAGE->set_url(new moodle_url('/local/bulk_enrolmanager/enrol_confirm.php'));
$PAGE->set_title('Confirm Enrolment');
$PAGE->set_heading('Confirm Enrolment');

// Actual enrolment logic here
if ($userids) {
    $users = explode(',', $userids);
    foreach ($users as $userid) {
        // Call your existing enrolment function
        enrol_user_into_course($userid, $courseid);
    }
}

redirect(
    new moodle_url('/local/bulk_enrolmanager/index.php'),
    'Users successfully enrolled into course!',
    3,
    \core\output\notification::NOTIFY_SUCCESS
);
