<?php
require('../../config.php');

$cmid = required_param('cmid', PARAM_INT);
require_login();

$cm = get_coursemodule_from_id('quiz', $cmid, 0, false, MUST_EXIST);
$context = context_module::instance($cmid);
require_capability('local/customquiz:view', $context);

$PAGE->set_context($context);
$PAGE->set_url('/local/customquiz/index.php', ['cmid' => $cmid]);
$PAGE->set_title('Exam');
$PAGE->set_heading('Exam');

$PAGE->requires->js_call_amd('local_customquiz/examui', 'init');
$PAGE->requires->css('/local/customquiz/styles.css');

echo $OUTPUT->header();
require($CFG->dirroot . '/mod/quiz/attempt.php');
echo $OUTPUT->footer();
