define([], function () {
    function init() {
        if (!document.body.id.includes('page-mod-quiz-attempt')) return;
        const nav = document.querySelector('.quiznavigation');
        if (!nav) return;

        const bar = document.createElement('div');
        bar.id = 'exam-status-bar';
        bar.innerHTML = `
            <div class="counts">
                <span class="attempted">Attempted: <b id="c-attempted">0</b></span>
                <span class="skipped">Skipped: <b id="c-skipped">0</b></span>
                <span class="review">Review: <b id="c-review">0</b></span>
                <span class="total">Total: <b id="c-total">0</b></span>
            </div>
            <div class="filters">
                <button data-filter="all">All</button>
                <button data-filter="attempted">Attempted</button>
                <button data-filter="skipped">Skipped</button>
                <button data-filter="review">Review</button>
            </div>
        `;
        nav.parentNode.insertBefore(bar, nav);

        const buttons = nav.querySelectorAll('.qnbutton');

        function updateCounts() {
            let attempted = 0, skipped = 0, review = 0;
            buttons.forEach(b => {
                if (b.classList.contains('answersaved')) attempted++;
                else skipped++;
                if (b.classList.contains('marked')) review++;
            });
            document.getElementById('c-attempted').innerText = attempted;
            document.getElementById('c-skipped').innerText = skipped;
            document.getElementById('c-review').innerText = review;
            document.getElementById('c-total').innerText = buttons.length;
        }

        function applyFilter(type) {
            buttons.forEach(b => {
                b.style.display = 'inline-flex';
                if (type === 'attempted' && !b.classList.contains('answersaved'))
                    b.style.display = 'none';
                if (type === 'skipped' && b.classList.contains('answersaved'))
                    b.style.display = 'none';
                if (type === 'review' && !b.classList.contains('marked'))
                    b.style.display = 'none';
            });
        }

        bar.querySelectorAll('.filters button').forEach(btn => {
            btn.addEventListener('click', () => applyFilter(btn.dataset.filter));
        });

        updateCounts();
        document.addEventListener('click', updateCounts);
        document.addEventListener('change', updateCounts);
    }
    return { init };
});
