document.addEventListener("DOMContentLoaded", function () {
    console.log("custom.js loaded");

    /* =========================
       Submenu toggle
    ========================== */
    const toggles = document.querySelectorAll(".submenu-toggle");

    if (toggles.length) {
        toggles.forEach(function (toggle) {
            toggle.addEventListener("click", function (e) {
                e.preventDefault();

                const parent = toggle.closest(".has-submenu");

                // ✅ prevent null error
                if (parent) {
                    parent.classList.toggle("open");
                }
            });
        });
    }

    /* =========================
       Sidebar toggle
    ========================== */
    const toggleBtn = document.getElementById('sidebarToggle');
    const sidebar = document.getElementById('custom-sidebar');

    if (toggleBtn && sidebar) {
        toggleBtn.addEventListener('click', function () {
            sidebar.classList.toggle('active');
        });
    }

    /* =========================
       Hide navigation on upload user page
    ========================== */
    if (window.location.pathname.indexOf("admin/tool/uploaduser/index.php") !== -1) {

        const nav = document.querySelector(".secondary-navigation.d-print-none");
        if (nav) {
            nav.style.display = "none";
        }

        const settings = document.getElementById('id_settingsheader');
        const defaults = document.getElementById('id_defaultheader');

        if (settings) settings.style.display = 'none';
        if (defaults) defaults.style.display = 'none';
    }

});
