/**
 * Controls the requests section of the contacts page.
 *
 * @module     core_message/message_drawer_view_contacts_section_requests
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_message/message_drawer_view_contacts_section_requests",["jquery","core/notification","core/pubsub","core/templates","core_message/message_repository","core_message/message_drawer_events","core_message/message_drawer_lazy_load_list"],(function($,Notification,PubSub,Templates,MessageRepository,MessageDrawerEvents,LazyLoadList){var SELECTORS_CONTACT_REQUEST='[data-region="contact-request"]',TEMPLATES_REQUESTS_LIST="core_message/message_drawer_view_contacts_body_section_requests_list",render=function(contentContainer,requests){var formattedRequests=requests.map((function(request){return{id:request.id,profileimageurl:request.profileimageurl,fullname:request.fullname}}));return Templates.render(TEMPLATES_REQUESTS_LIST,{requests:formattedRequests}).then((function(html){return contentContainer.append(html),html})).catch(Notification.exception)},load=function(listRoot,userId){return MessageRepository.getContactRequests(userId).then((function(requests){return LazyLoadList.setLoadedAll(listRoot,!0),requests})).catch(Notification.exception)},handleContactRequestProcessed=function(root){return function(request){root.find('[data-request-id="'+request.userid+'"]').remove(),root.find(SELECTORS_CONTACT_REQUEST).length||(LazyLoadList.showEmptyMessage(root),LazyLoadList.hideContent(root))}};return{show:function(root){root.attr("data-contacts-init")||(!function(root){PubSub.subscribe(MessageDrawerEvents.CONTACT_REQUEST_ACCEPTED,handleContactRequestProcessed(root)),PubSub.subscribe(MessageDrawerEvents.CONTACT_REQUEST_DECLINED,handleContactRequestProcessed(root))}(root),root.attr("data-contacts-init",!0)),LazyLoadList.show(root,load,render)}}}));

//# sourceMappingURL=message_drawer_view_contacts_section_requests.min.js.map