<?php
require(__DIR__ . '/../../config.php');
require_once($CFG->dirroot . '/mod/quiz/locallib.php');
require_once($CFG->dirroot . '/mod/quiz/editlib.php');

$cmid   = required_param('cmid', PARAM_INT);
$slotid = required_param('remove', PARAM_INT);
require_sesskey();

/* Load CM, Course, Quiz */
$cm = get_coursemodule_from_id('quiz', $cmid, 0, false, MUST_EXIST);
$course = get_course($cm->course);
$quiz = $DB->get_record('quiz', ['id' => $cm->instance], '*', MUST_EXIST);

$context = context_module::instance($cmid);

require_login($course, false, $cm);
require_capability('mod/quiz:manage', $context);

/* Moodle default quiz object */
$quizobj = new quiz($quiz, $cm, $course);
$structure = $quizobj->get_structure();

/* Remove slot */
$structure->remove_slot($slotid);
$structure->refresh_page_numbers_and_update_grades();

/* Redirect back */
redirect(
    new moodle_url('/local/quiztools/index.php', ['cmid' => $cmid]),
    get_string('changessaved'),
    null,
    \core\output\notification::NOTIFY_SUCCESS
);
