document.addEventListener('DOMContentLoaded', function () {

    const addBtn = document.getElementById('add-selected');
    if (!addBtn) {
        console.error('Add button not found');
        return;
    }

    addBtn.addEventListener('click', function () {

        const checked = document.querySelectorAll('.qcheck:checked');

        if (!checked.length) {
            alert('Please select at least one question');
            return;
        }

        const params = new URLSearchParams();
        params.append('cmid', window.LOCAL_QUIZTOOLS_CMID);
        params.append('sesskey', M.cfg.sesskey);

        checked.forEach(cb => {
            params.append('questionids[]', cb.value);
        });

        console.log('Redirecting to addquestion.php', params.toString());

        window.location.href =
            M.cfg.wwwroot + '/local/quiztools/addquestion.php?' + params.toString();
    });

    // Optional: Select all
    const selectAll = document.getElementById('select-all');
    if (selectAll) {
        selectAll.addEventListener('change', function () {
            document.querySelectorAll('.qcheck').forEach(cb => {
                cb.checked = selectAll.checked;
            });
        });
    }
});
