<?php
require(__DIR__ . '/../../config.php');
require_once($CFG->dirroot . '/mod/quiz/locallib.php');
require_once($CFG->dirroot . '/mod/quiz/classes/structure.php');

global $DB, $PAGE, $OUTPUT;

/* ===================== REQUIRED PARAM ===================== */
$cmid = required_param('cmid', PARAM_INT);

/* ===================== COURSE + CM (IMPORTANT) ===================== */
/*
  STEP 1:
  - get_coursemodule_from_id() is ONLY used to get course id
  - DO NOT use it for quiz structure
*/
$cmrecord = get_coursemodule_from_id('quiz', $cmid, 0, false, MUST_EXIST);
$course   = get_course($cmrecord->course);

/*
  STEP 2:
  - get REAL cm_info object (THIS FIXES YOUR ERROR)
*/
$cm = get_fast_modinfo($course)->get_cm($cmid);

/* ===================== CONTEXT + LOGIN ===================== */
$context = context_module::instance($cmid);

require_login($course, false, $cm);
require_capability('local/quiztools:view', $context);


/* ===================== CONTINUE WITH YOUR EXISTING CODE ===================== */
// DO NOT CHANGE anything below this line


/* ===================== UI CSS ONLY ===================== */
echo '<style>
.secondary-navigation.d-print-none { display:none !important; }
.table-scroll { max-height: 420px; overflow-y: auto; }
</style>';

/* ===================== COURSE CATEGORIES ===================== */
$coursecategories = $DB->get_records_menu(
    'course_categories',
    ['visible' => 1],
    'name ASC',
    'id, name'
);

$coursecatid = optional_param('coursecatid', 0, PARAM_INT);
$searchtext = optional_param('searchtext', '', PARAM_TEXT);


/* ===================== QUESTION IDS ALREADY ADDED ===================== */
$addedquestionids = $DB->get_fieldset_sql("
    SELECT qv.questionid
      FROM {quiz_slots} qs
      JOIN {question_references} qr ON qr.itemid = qs.id
      JOIN {question_bank_entries} qbe ON qbe.id = qr.questionbankentryid
      JOIN {question_versions} qv ON qv.questionbankentryid = qbe.id
     WHERE qs.quizid = ?
       AND qv.status = 'ready'
", [$cm->instance]);

/* ===================== AVAILABLE QUESTIONS ===================== */
$where  = 'q.parent = 0';
$params = [];

if ($coursecatid) {
    $where .= ' AND qc.idnumber = :idnumber';
    $params['idnumber'] = 'coursecat_' . $coursecatid;
}

if (!empty($searchtext)) {
    $where .= " AND " . $DB->sql_like('q.questiontext', ':searchtext', false);
    $params['searchtext'] = '%' . $DB->sql_like_escape($searchtext) . '%';
}

if (!empty($addedquestionids)) {
    list($notinsql, $notinparams) = $DB->get_in_or_equal(
        $addedquestionids,
        SQL_PARAMS_NAMED,
        'exq',
        false
    );
    $where .= " AND q.id $notinsql";
    $params = array_merge($params, $notinparams);
}

$questions = $DB->get_records_sql("
    SELECT q.id, q.name, q.qtype, q.questiontext, q.timecreated
      FROM {question} q
      JOIN {question_categories} qc ON qc.id = q.category
     WHERE $where
  ORDER BY q.id DESC
", $params);

/* ===================== ADDED QUESTIONS ===================== */
$addedquestions = $DB->get_records_sql("
    SELECT
        qs.id AS slotid,
        q.name,
        q.qtype,
        q.questiontext,
        q.timecreated,
        qc.name AS category
    FROM {quiz_slots} qs
    JOIN {question_references} qr ON qr.itemid = qs.id
    JOIN {question_bank_entries} qbe ON qbe.id = qr.questionbankentryid
    JOIN {question_versions} qv ON qv.questionbankentryid = qbe.id
    JOIN {question} q ON q.id = qv.questionid
    JOIN {question_categories} qc ON qc.id = q.category
    WHERE qs.quizid = ?
      AND qv.status = 'ready'
    ORDER BY qs.slot
", [$cm->instance]);

/* ===================== PAGE SETUP ===================== */
$PAGE->set_url(new moodle_url('/local/quiztools/index.php', ['cmid' => $cmid]));
$PAGE->set_pagelayout('incourse');
$PAGE->set_title('Add Questions');
$PAGE->set_heading($course->fullname);

/* ===================== JS (UNCHANGED LOGIC) ===================== */
$PAGE->requires->js_init_code("
document.addEventListener('DOMContentLoaded', function () {

    const addBtn = document.getElementById('add-selected');
    if (!addBtn) return;

    addBtn.addEventListener('click', function () {

        const checked = document.querySelectorAll('.qcheck:checked');
        if (!checked.length) {
            alert('Please select at least one question');
            return;
        }

        const params = new URLSearchParams();
        params.append('cmid', {$cmid});
        params.append('sesskey', M.cfg.sesskey);

        checked.forEach(cb => {
            params.append('questionids[]', cb.value);
        });

        window.location.href =
            M.cfg.wwwroot + '/local/quiztools/addquestion.php?' + params.toString();
    });

    const selectAll = document.getElementById('select-all');
    if (selectAll) {
        selectAll.addEventListener('change', function () {
            document.querySelectorAll('.qcheck').forEach(cb => {
                cb.checked = selectAll.checked;
            });
        });
    }
});
");

echo $OUTPUT->header();

/* ===================== HEADER ===================== */
echo $OUTPUT->heading(
    'Add Questions to ' . format_string($cmrecord->name),
    2
);

?>


<div class="container-fluid mt-4">

<!-- ================= FILTER ================= -->
<form method="get" class="card mb-4 p-3">
    <input type="hidden" name="cmid" value="<?= $cmid ?>">
   <div class="row g-2 align-items-center">

    <div class="col-md-4">
        <select name="coursecatid" class="form-select">
            <option value="">Select Course Category</option>
            <?php foreach ($coursecategories as $id => $name): ?>
                <option value="<?= $id ?>" <?= $coursecatid == $id ? 'selected' : '' ?>>
                    <?= format_string($name) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>

    <div class="col-md-4">
        <input type="text"
               name="searchtext"
               class="form-control"
               placeholder="Search question text..."
               value="<?= s($searchtext) ?>">
    </div>

    <div class="col-md-4 d-grid">
        <button type="submit" class="btn btn-primary">
            <?= $OUTPUT->pix_icon('a/search', 'Search'); ?> Load Question
        </button>
    </div>

</div>
</form>

<?php if ($coursecatid): ?>

<!-- ================= AVAILABLE QUESTIONS TABLE ================= -->
<div class="card mb-4">
    <div class="card-header fw-bold">Available Questions</div>
    <div class="table-responsive table-scroll">
        <table class="table table-striped align-middle mb-0">
            <thead class="table-light">
                <tr>
                     <th>S.No</th>
                    <th><input type="checkbox" id="select-all"></th>
                    <th>Question</th>
                    <!-- <th>Question Text</th> -->
                   
                    <th>Created On</th>
                </tr>
            </thead>
            <tbody>

              <?php if ($questions):
                $i = 1;
                foreach ($questions as $q): ?>
                <tr>
                    <td><?= $i++ ?></td>
                    <td><input type="checkbox" class="qcheck" value="<?= $q->id ?>"></td>
                    <!-- <td><?= format_string($q->name) ?></td> -->
                <td style="
    max-width:400px;
    white-space: normal;
    word-wrap: break-word;
">
<?php
    $text = trim(strip_tags(format_text(
        $q->questiontext,
        $q->questiontextformat,
        ['noclean' => true]
    )));

    if (core_text::strlen($text) > 70) {
        $text = core_text::substr($text, 0, 70) . '...';
    }

    echo s($text);
?>
</td>


                   
                    <td><?= userdate($q->timecreated, '%e-%b-%Y') ?></td>
                </tr>
            <?php endforeach; else: ?>
                <tr><td colspan="4" class="text-center text-muted">No questions available</td></tr>
            <?php endif; ?>
            </tbody>
        </table>
    </div>
    <div class="p-3">
        <button type="button" class="btn btn-primary" id="add-selected">
            Add Selected Questions
        </button>
    </div>
</div>

<!-- ================= ADDED QUESTIONS TABLE ================= -->
<!-- ================= ADDED QUESTIONS TABLE ================= -->
<div class="card">
    <div class="card-header fw-bold">Questions Added to Assessment</div>

    <div class="table-responsive table-scroll">
        <table class="table table-striped align-middle mb-0">
            <thead class="table-light">
                <tr>
                    <th>S.No</th>
                    <th>Question</th>
                    <!-- <th>Question Text</th> -->
                  
                    <th>Category</th>
                    <th>Created On</th>
                    <!-- <th class="text-center">Remove</th> -->
                </tr>
            </thead>
            <tbody>

            <?php if ($addedquestions):
                $j = 1;
                foreach ($addedquestions as $aq): ?>

                <tr>
                    <td><?= $j++ ?></td>
                    <!-- <td><?= format_string($aq->name) ?></td> -->
                  <td style="
    max-width:400px;
    white-space: normal;
    word-wrap: break-word;
">
<?php
    $text = trim(strip_tags(format_text(
        $aq->questiontext,
        $aq->questiontextformat,
        ['noclean' => true]
    )));

    if (core_text::strlen($text) > 70) {
        $text = core_text::substr($text, 0, 70) . '...';
    }

    echo s($text);
?>
</td>


                   
                    <td><?= format_string(preg_replace('/^Category\s+/i', '', $aq->category)) ?></td>
                    <td><?= userdate($aq->timecreated, '%e-%b-%Y') ?></td>

                    <!-- <td class="text-center">
                        <a href="<?= new moodle_url('/local/quiztools/remove.php', [
                                'cmid'   => $cmid,
                                
                                'sesskey'=> sesskey(),
                                 'remove' => $aq->slotid
                            ]) ?>"
                           class="btn btn-sm btn-danger"
                           onclick="return confirm('Remove this question from the assessment?');">

                            <?= $OUTPUT->pix_icon('t/delete', 'Remove') ?>

                        </a>
                    </td> -->
                </tr>

            <?php endforeach; else: ?>

                <tr>
                    <td colspan="6" class="text-center text-muted">
                        No questions added yet
                    </td>
                </tr>

            <?php endif; ?>

            </tbody>
        </table>
    </div>
</div>

<?php endif; ?>

</div>

<?php
echo $OUTPUT->footer();
