<?php
define('AJAX_SCRIPT', true);
require_once(__DIR__ . '/../../../config.php');

require_login();
require_sesskey();

global $DB, $USER;

$data = json_decode(file_get_contents('php://input'));

if (empty($data->attemptid) || empty($data->slot)) {
    throw new moodle_exception('invalidrequest');
}

$params = [
    'attemptid' => (int)$data->attemptid,
    'slot'      => (int)$data->slot
];

if (!$DB->record_exists('questiontracker_visit', $params)) {
    $record = (object)[
        'attemptid'   => $params['attemptid'],
        'slot'        => $params['slot'],
        'userid'      => $USER->id,
        'timevisited' => time()
    ];
    $DB->insert_record('questiontracker_visit', $record);
}

echo json_encode(['status' => 'ok']);
