<?php
require_once(__DIR__ . '/../../config.php');
require_login();
global $DB, $USER;

// Capability check
$context = context_system::instance();
require_capability('moodle/site:config', $context);

// 🔥 REQUIRED – without this update_record will NOT run
require_sesskey();

// Validate required params
$pathid     = required_param('pathid', PARAM_INT);
$lab_points = required_param('lab_points', PARAM_INT);

// Build update object
$record = new stdClass();
$record->id = $pathid;              // Primary key
$record->creditpoints = $lab_points; // Field name must match DB field
$record->timemodified = time();

// Perform update
$DB->update_record('learning_paths', $record);

// Redirect back with success message
redirect(
    new moodle_url('/local/learningpath/manage.php'),
    'Lab credit points updated successfully!',
    null,
    \core\output\notification::NOTIFY_SUCCESS
);
