<?php
// File: local/learningpath/learner_path_view.php
require_once('../../config.php');
require_login();
require_once($CFG->dirroot . '/mod/quiz/locallib.php');

global $DB, $USER, $PAGE, $OUTPUT, $CFG;

$pathid = required_param('id', PARAM_INT);

$PAGE->set_url(new moodle_url('/local/learningpath/learner_path_view.php', ['id' => $pathid]));
$PAGE->set_context(context_system::instance());

// include CSS
$cssfile = new moodle_url('/local/learningpath/learner_styles.css');
$PAGE->requires->css($cssfile);

// fetch learning path
$lp = $DB->get_record('learning_paths', ['id' => $pathid], '*', MUST_EXIST);

// fetch sections ordered by position
$sections = $DB->get_records('learning_path_sections', ['learningpathid' => $pathid], 'position ASC');

$PAGE->set_title(format_string($lp->name));
$PAGE->set_heading(format_string($lp->name));

echo $OUTPUT->header();

global $SESSION, $PAGE;

// Use system context OR any course context
$syscontext = context_system::instance();

// Show button ONLY if:
// 1) role was switched via switchrole.php
// 2) user is Manager/Teacher (can switch roles)
// if (!empty($SESSION->autoswitched) && has_capability('moodle/role:switchroles', $syscontext)) {

//     $returnurl = new moodle_url('/local/learningpath/restore.php');

//     echo '<div style="margin:10px 0; text-align:right;">
//             <a href="'.$returnurl->out(false).'" class="btn btn-warning">
//                 Return to Admin mode
//             </a>
//           </div>';
// }


echo '<style>
/* PASS badge */
.pass-badge {
    background-color: #d1e7dd;
    color: #0f5132;
    border: 1px solid #badbcc;
    padding: 4px 10px;
    border-radius: 12px;
    font-size: 13px;
    font-weight: 600;
    white-space: nowrap;
}

/* FAIL badge */
.fail-badge {
    background-color: #f8d7da;
    color: #842029;
    border: 1px solid #f5c2c7;
    padding: 4px 10px;
    border-radius: 12px;
    font-size: 13px;
    font-weight: 600;
    white-space: nowrap;
}
</style>';



function get_quiz_lp_status($quizid, $userid) {
    global $DB;

    // 1️⃣ Check if there is at least ONE finished attempt
    $hasfinished = $DB->record_exists_sql("
        SELECT 1
          FROM {quiz_attempts}
         WHERE quiz = :quiz
           AND userid = :uid
           AND state = 'finished'
    ", [
        'quiz' => $quizid,
        'uid'  => $userid
    ]);

    // ❌ No finished attempt → show nothing
    if (!$hasfinished) {
        return [null, null];
    }

    // 2️⃣ Get FINAL grade (this already respects grading method)
    // Highest / Average / First / Last → Moodle decides
    $finalgrade = $DB->get_field('quiz_grades', 'grade', [
        'quiz'   => $quizid,
        'userid' => $userid
    ]);

    if ($finalgrade === null) {
        return ['Fail', 'fail-badge'];
    }

    // 3️⃣ Get Grade to pass (ONLY correct source)
    $gradepass = $DB->get_field_sql("
        SELECT gi.gradepass
          FROM {grade_items} gi
         WHERE gi.itemtype     = 'mod'
           AND gi.itemmodule   = 'quiz'
           AND gi.iteminstance = :quizid
    ", ['quizid' => $quizid]);

    $gradepass = ($gradepass !== null) ? (float)$gradepass : 0;

    // 4️⃣ Compare FINAL grade with pass grade
    if ($gradepass > 0 && $finalgrade >= $gradepass) {
        return ['Pass', 'pass-badge'];
    }

    return ['Fail', 'fail-badge'];
}




// function get_quiz_lp_status($quizid, $userid) {
//     global $DB;

//     // Get latest attempt (any state)
//     $attempt = $DB->get_record_sql("
//         SELECT *
//           FROM {quiz_attempts}
//          WHERE quiz = :quiz
//            AND userid = :uid
//       ORDER BY timemodified DESC
//          LIMIT 1
//     ", [
//         'quiz' => $quizid,
//         'uid'  => $userid
//     ]);

//     // ❌ No attempt → no badge
//     if (!$attempt) {
//         return [null, null];
//     }

//     // ❌ Attempt running → no badge
//     if ($attempt->state !== 'finished') {
//         return [null, null];
//     }

//     // ✅ LAST finished attempt → check PASS / FAIL
//     $quiz = $DB->get_record('quiz', ['id' => $quizid], '*', MUST_EXIST);

//     // Final grade (last finished attempt)
//     $grade = $DB->get_field('quiz_grades', 'grade', [
//         'quiz'   => $quizid,
//         'userid' => $userid
//     ]);

//     if ($grade === false || $quiz->grade <= 0) {
//         return ['Fail', 'fail-badge'];
//     }

//     $percentage = ($grade / $quiz->grade) * 100;

//     if ($percentage >= $quiz->gradepass) {
//         return ['Pass', 'pass-badge'];
//     } else {
//         return ['Fail', 'fail-badge'];
//     }
// }





function get_latest_finished_quiz_attempt($quizid, $userid) {
    global $DB;

    return $DB->get_record_sql("
        SELECT *
          FROM {quiz_attempts}
         WHERE quiz = :quiz
           AND userid = :uid
           AND state = 'finished'
      ORDER BY timemodified DESC
         LIMIT 1
    ", [
        'quiz' => $quizid,
        'uid'  => $userid
    ]);
}



// 🔙 Back button
$backurl = new moodle_url('/local/custompage/training2.php');

echo '<div style="margin-bottom:10px; text-align:right;">
        <a href="'.$backurl->out(false).'" class="btn btn-secondary">
            ← Back
        </a>
      </div>';


echo '<div class="lp-container">';

// header / hero
echo '<div class="lp-hero">';

echo '<div>';
echo '<div class="title">' . format_string($lp->name) . '</div>';
echo '<div class="sub">' . ($lp->description ? format_text($lp->description, FORMAT_HTML) : '') . '</div>';
echo '</div>';

echo '<div style="text-align:right"></div>';
echo '</div>'; // hero

// Tabs
echo '<div class="lp-tabs" id="lpTabs">';
$idx = 0;
foreach ($sections as $s) {
    $name = $s->sectionname ? $s->sectionname : 'Section ' . ($idx + 1);
    echo '<div class="lp-tab ' . ($idx===0 ? 'active' : '') . '" data-id="' . $s->id . '">' . format_string($name) . '</div>';
    $idx++;
}
echo '</div>';

// Section contents
$idx = 0;
foreach ($sections as $s) {

    // fetch courses in this section ordered
    $courses = $DB->get_records('learning_path_courses', ['sectionid' => $s->id], 'sortorder ASC');

    // ****** UNLOCKED ALWAYS ******
    $section_unlocked = true;   // <-- ALWAYS TRUE
    // *****************************

    $display_style = ($idx === 0) ? '' : 'style="display:none"';
    echo '<div id="section_content_' . $s->id . '" class="section-wrap" ' . $display_style . '>';

    // compute progress
    $total = count($courses);
    $completed = 0;
    foreach ($courses as $c) {
        $cc = $DB->get_record('course_completions', ['userid' => $USER->id, 'course' => $c->courseid]);
        if ($cc && !empty($cc->timecompleted)) $completed++;
    }
    $secpct = ($total > 0) ? intval(($completed / $total) * 100) : 100;

    echo '<div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:12px">';
  //  echo '<div><strong>' . format_string($s->sectionname) . '</strong></div>';
    echo '<div style="display:flex;align-items:center;gap:10px">';

    // ****** NO LOCK BADGE ANYMORE ******
    if ($total > 0 && $completed === $total) {
        echo '<div class="completed-badge">Completed</div>';
    }
    // ************************************

    echo '</div></div>';

    // courses list
    if (empty($courses)) {
        echo '<div class="card p-3">No courses in this section.</div>';
    } else {
        foreach ($courses as $c) {

    if ($c->activitytype === 'quiz' && !empty($c->quizid)) {

    require_once($CFG->dirroot . '/mod/quiz/locallib.php');

    $quiz = $DB->get_record('quiz', ['id' => $c->quizid]);
    if (!$quiz) {
        continue; // quiz deleted → skip silently
    }

    $cm = get_coursemodule_from_instance('quiz', $quiz->id, $quiz->course);
    if (!$cm) {
        continue; // course module missing → skip
    }

    list($status, $statusclass) = get_quiz_lp_status($quiz->id, $USER->id);
   // $statusbadge = '<div class="'.$statusclass.'">'.$status.'</div>';
$statusbadge = '';
if (!empty($status)) {
    $statusbadge = '<div class="'.$statusclass.'">'.$status.'</div>';
}

    if ($status === 'Pass' || $status === 'Fail') {
    // Quiz attempted → View result page
    $quizurl = new moodle_url('/mod/quiz/view.php', ['id' => $cm->id]);
    $btntext = 'View';
} else {
    // Not attempted yet → Start quiz
    $quizobj = quiz::create($quiz->id, $USER->id);
    $quizurl = $quizobj->start_attempt_url();
    $btntext = 'Start';
}
$context = context_course::instance($quiz->course);

// Decide final URL
if (has_capability('moodle/role:switchroles', $context)) {

    // Manager / Teacher → go via switchrole.php
    $finalurl = new moodle_url('/local/learningpath/switchrole.php', [
        'redirect' => $quizurl->out(false),
        'courseid' => $quiz->course,
         'sesskey'  => sesskey() 
    ]);

} else {

    // Normal user → direct quiz URL
    $finalurl = $quizurl;
}

echo '<div class="course-row">
        <div class="course-left">
            <div class="course-meta">
                <h4>' . format_string($quiz->name) . '</h4>
                <p>' . ($quiz->intro ? strip_tags(format_text($quiz->intro, FORMAT_HTML)) : '&nbsp;') . '</p>
            </div>
        </div>
        <div style="display:flex;align-items:center;gap:12px">
            ' . $statusbadge . '
            <a class="course-start" href="' . $finalurl->out(false) . '">' . $btntext . '</a>
        </div>
      </div>';

continue;

}




            $cc = $DB->get_record('course_completions', ['userid' => $USER->id, 'course' => $c->courseid]);
            $iscompleted = ($cc && !empty($cc->timecompleted));
          $courseurl = new moodle_url('/course/view.php', [
    'id'   => $c->courseid,
    'lpid' => $pathid
]);

            // ****** BUTTON ALWAYS ENABLED ******
            $btnclass = 'course-start';
            $btndisabled = false;
            // ***********************************

           // 🔥 DYNAMIC STATUS BADGE (Reads from local_ltiprogress)
$statusraw = $DB->get_field_sql("
    SELECT lp.activityprogress
      FROM {local_ltiprogress} lp
     WHERE lp.userid = :uid
       AND lp.ltiid  = :cid
  ORDER BY lp.timemodified DESC, lp.timecreated DESC
     LIMIT 1
", [
    'uid' => $USER->id,
    'cid' => $c->courseid
]);

// Default if no record
$statusraw = $statusraw ? trim($statusraw) : 'Not Started';

// Normalize
$label = strtolower($statusraw);

// Decide badge (EXACT mapping)
switch ($label) {

    case 'completed':
        $status      = 'Completed';
        $statusclass = 'completed-badge';
        break;

    case 'in progress':
    case 'inprogress':
        $status      = 'In Progress';
        $statusclass = 'progress-badge';
        break;

    case 'started':
        $status      = 'Started';
        $statusclass = 'started-badge';
        break;

    default:
        $status      = 'Not Started';
        $statusclass = 'notstarted-badge';
        break;
}

$statusbadge = '<div class="' . $statusclass . '">' . $status . '</div>';


$courseobj = $DB->get_record('course', ['id' => $c->courseid]);
if (!$courseobj) {
    continue; // course deleted → skip
}
           $initials = htmlspecialchars(substr($courseobj->fullname, 0, 2));
            echo '<div class="course-row">';
            echo '  <div class="course-left">';
           // echo '    <div class="course-thumb">' . $initials . '</div>';
            echo '    <div class="course-meta">';


           
echo '      <h4>' . format_string($courseobj->fullname) . '</h4>';
$summary = $courseobj->summary;
            
            echo '      <p>' . ($summary ? strip_tags(format_text($summary, FORMAT_HTML)) : '&nbsp;') . '</p>';
            echo '    </div>';
            echo '  </div>';

            echo '  <div style="display:flex;align-items:center;gap:12px">';
            echo $statusbadge;
            echo '<a class="course-start" href="' . $courseurl->out(false) . '">' . ($iscompleted ? 'View' : 'Start') . '</a>';
            echo '  </div>';

            echo '</div>';
        }
    }

    echo '</div>'; // section wrap
    $idx++;
}

echo '</div>'; // container

// JS
$js = <<<JS
(function(){
  var tabs = document.querySelectorAll('.lp-tab');
  if (!tabs) return;
  tabs.forEach(function(tab){
    tab.addEventListener('click', function(){
      var id = this.getAttribute('data-id');
      tabs.forEach(t=>t.classList.remove('active'));
      this.classList.add('active');
      document.querySelectorAll('[id^="section_content_"]').forEach(el => el.style.display = 'none');
      var show = document.getElementById('section_content_' + id);
      if (show) show.style.display = '';
    });
  });
})();
JS;

$PAGE->requires->js_init_code($js);

echo $OUTPUT->footer();
exit;
