<?php
require_once(__DIR__ . '/../../config.php');
require_login();

global $DB, $PAGE, $OUTPUT;

$id = required_param('id', PARAM_INT);   // learning_paths.id

$context = context_system::instance();
require_capability('moodle/site:config', $context);

/* =========================================================
   LOAD LEARNING PATH
========================================================= */
$lp = $DB->get_record('learning_paths', ['id'=>$id], '*', MUST_EXIST);

/* ===========================================
   BUILD STRUCTURE FROM DB
=========================================== */
$sections = $DB->get_records('learning_path_sections', ['learningpathid'=>$id],'position ASC');
$structure = [];

foreach ($sections as $sec) {

    $items = $DB->get_records('learning_path_courses',['sectionid'=>$sec->id],'sortorder ASC');
    $sectionitems = [];

    foreach ($items as $it) {

        if ($it->activitytype == 'quiz') {
            $q = $DB->get_record('quiz',['id'=>$it->quizid],'id,name');
            $sectionitems[] = [
                'id'=>$it->quizid,
                'type'=>'quiz',
                'name'=>$q ? $q->name : 'Quiz '.$it->quizid
            ];
        } else {
            $c = $DB->get_record('course',['id'=>$it->courseid],'id,fullname');
            $sectionitems[] = [
                'id'=>$it->courseid,
                'type'=>'course',
                'name'=>$c ? $c->fullname : 'Course '.$it->courseid
            ];
        }
    }

    $sectiontype = [1=>'aws',2=>'practice',3=>'online',4=>'lab',5=>'reading'][$sec->sectiontype] ?? 'aws';

    $structure[] = [
        'title'=>$sec->sectionname,
        'type'=>$sectiontype,
        'items'=>$sectionitems
    ];
}

/* =========================================================
   AJAX → UNIQUE NAME CHECK (ignore itself)
========================================================= */
if (optional_param('ajax', 0, PARAM_BOOL)) {
    require_sesskey();
    $name = required_param('name', PARAM_TEXT);

    $exists = $DB->record_exists_select(
        'learning_paths',
        'name = ? AND id <> ?',
        [$name, $id]
    );

    echo json_encode(['exists' => $exists]);
    exit;
}

/* =========================================================
   PAGE SETUP
========================================================= */
$PAGE->set_context($context);
$PAGE->set_url(new moodle_url('/local/learningpath/edit2.php', ['id' => $id]));
$PAGE->set_title('Edit Learning Path');
$PAGE->set_heading('Edit Learning Path');

/* =========================================================
   DATA (same as create)
========================================================= */
$categories = $DB->get_records('course_categories', null, 'name ASC');

$rawlangs = $DB->get_records_sql_menu("
    SELECT DISTINCT lang AS id, lang
    FROM {course}
    WHERE lang IS NOT NULL AND lang <> ''
    ORDER BY lang ASC
");

$langnames = [
    'ar-SA'=>'Arabic (Saudi Arabia)','de-DE'=>'German (Germany)','en-US'=>'English (US)',
    'es-419'=>'Spanish (Latin America)','es-ES'=>'Spanish (Spain)','fr-FR'=>'French',
    'id-ID'=>'Indonesian','it-IT'=>'Italian','ja-JP'=>'Japanese','ko-KR'=>'Korean',
    'pt-BR'=>'Portuguese (Brazil)','zh-CN'=>'Chinese (Simplified)','zh-TW'=>'Chinese (Traditional)',
    'th-TH'=>'Thai','vi-VN'=>'Vietnamese','he-IL'=>'Hebrew','el-GR'=>'Greek',
    'pl-PL'=>'Polish','tr-TR'=>'Turkish','uk-UA'=>'Ukrainian'
];

echo $OUTPUT->header();
?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-rc.0/css/select2.min.css"/>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>

<div class="container-fluid">
  <div class="card shadow-sm p-4 mb-4">

    <div class="d-flex justify-content-between mb-3">
      <h4>Edit Learning Path</h4>
      <a href="manage.php" class="btn btn-outline-secondary btn-sm">Back</a>
    </div>

    <form id="lpCreateForm" method="post" action="update2.php" enctype="multipart/form-data">
      <input type="hidden" name="sesskey" value="<?= sesskey() ?>">
      <input type="hidden" name="id" value="<?= $lp->id ?>">
      <input type="hidden" name="structure_json" id="structure_json">

      <!-- GLOBAL CATEGORY -->
      <div class="mb-3">
        <label class="form-label"><strong>Category</strong></label>
        <select id="categorySelect" name="category_id" class="form-control" required>
          <?php foreach ($categories as $cat): ?>
            <option value="<?= $cat->id ?>" <?= $cat->id==$lp->category_id?'selected':'' ?>>
              <?= format_string($cat->name) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <!-- Learning Path Details -->
      <div class="card bg-light p-3 mb-3">
        <h5>Learning Path Details</h5>

        <div class="mb-2">
          <label class="form-label">Name</label>
          <input type="text" name="name" id="lp_name" class="form-control" value="<?= s($lp->name) ?>" required>
          <div id="lp_name_error" class="text-danger small d-none">
            Learning Path name already exists
          </div>
        </div>

        <div class="row g-2">
          <div class="col-md-6">
            <label class="form-label">Image</label>
            <input type="file" name="image" class="form-control">
            <?php if (!empty($lp->image)): ?>
              <small class="text-muted">Current: <?= s($lp->image) ?></small>
            <?php endif; ?>
          </div>
          <div class="col-md-6">
            <label class="form-label">Level</label>
            <select name="level" class="form-control">
              <option <?= $lp->level=='Beginner'?'selected':'' ?>>Beginner</option>
              <option <?= $lp->level=='Intermediate'?'selected':'' ?>>Intermediate</option>
              <option <?= $lp->level=='Advanced'?'selected':'' ?>>Advanced</option>
            </select>
          </div>
        </div>
      </div>

      <!-- Sections (same container, JS will auto-fill) -->
      <div class="card bg-light p-3 mb-3">
        <h5>Sections</h5>
        <div id="sectionsContainer"></div>

        <button type="button" id="addSectionBtn" class="btn btn-primary mt-2">
          Add Heading
        </button>
      </div>

      <div class="mb-3">
        <label>Status</label>
        <select name="status" class="form-control">
          <option <?= $lp->status=='Publish'?'selected':'' ?>>Publish</option>
          <option <?= $lp->status=='Unpublish'?'selected':'' ?>>Unpublish</option>
        </select>
      </div>

      <div class="text-end">
        <button class="btn btn-success"><i class="fa fa-save"></i> Update Learning Path</button>
      </div>
    </form>
  </div>
</div>

<!-- SAME ACTIVITY MODAL AS CREATE -->
<div class="modal fade" id="activityModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">Add Activities</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal">X</button>
      </div>

      <div class="modal-body">

        <div class="mb-3" id="languageBlock">
          <label class="form-label"><strong>Language</strong></label>
          <select id="activityLanguageFilter" class="form-control">
            <option value="">All Languages</option>
            <?php foreach ($rawlangs as $code => $v): ?>
              <option value="<?= $code ?>"><?= $langnames[$code] ?? $code ?></option>
            <?php endforeach; ?>
          </select>
        </div>

        <label>Select Items</label>
        <select id="activityCourseSelect" style="width:100%" multiple></select>

      </div>

      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button id="activityAddBtn" class="btn btn-primary">Add to Section</button>
      </div>

    </div>
  </div>
</div>

<script>
window.lp_config = {
  sesskey: '<?= sesskey() ?>',
  ajaxCoursesUrl: '<?= (new moodle_url("/local/learningpath/get_courses2.php"))->out(false) ?>',
  basepath: '<?= (new moodle_url("/local/learningpath/"))->out(false) ?>'
};

window.lp_existing_data = <?= json_encode($structure) ?>;

// name check
$('#lp_name').on('blur', function () {
  let name = $(this).val().trim();
  if (!name) return;
  $.get(window.location.pathname, {
    ajax: 1, name: name, sesskey: '<?= sesskey() ?>'
  }, function (res) {
    $('#lp_name_error').toggleClass('d-none', !res.exists);
  }, 'json');
});
</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-rc.0/js/select2.min.js"></script>

<script src="js/learningpath2.js"></script>

<?php echo $OUTPUT->footer(); ?>
