<?php
require_once('../../config.php');

global $DB, $OUTPUT, $PAGE;

// No capability restriction (removed as requested).

$PAGE->set_url('/local/learningpath/assign.php');
$PAGE->set_pagelayout('standard');
$PAGE->set_title('Assign Learning Paths');
$PAGE->set_heading('Assign Learning Paths');

// Get all learning paths
$learningpaths = $DB->get_records('learning_paths');   // your table name may be mdl_learning_paths

// Get all cohorts (batches)
$batches = $DB->get_records('cohort');


// -----------------------------
// Handle form submission
// -----------------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $selectedlps = isset($_POST['learningpaths']) ? $_POST['learningpaths'] : [];
    $selectedbatches = isset($_POST['batches']) ? $_POST['batches'] : [];

    foreach ($selectedlps as $lpid) {
        foreach ($selectedbatches as $batchid) {

            // Insert enrolment if not exists
            $exists = $DB->record_exists('learning_path_enrolments', [
                'learningpathid' => $lpid,
                'cohortid'       => $batchid
            ]);

            if (!$exists) {
                $rec = new stdClass();
                $rec->learningpathid = $lpid;
                $rec->cohortid = $batchid;
                $rec->userid = null;
                $rec->enroltype = 'cohort';
                $rec->timecreated = time();
                $DB->insert_record('learning_path_enrolments', $rec);
            }
        }
    }

    redirect(new moodle_url('/local/learningpath/assign.php'), 'Learning Path Assigned Successfully', 2);
}


echo $OUTPUT->header();
?>


<style>
.lp-box {
    border: 1px solid #ddd; 
    padding: 12px;
    margin-bottom: 12px;
    border-radius: 6px;
    background: #fff;
}

.batch-box {
    border: 1px solid #ddd;
    padding: 12px;
    height: 300px;
    overflow-y: auto;
    background: #fff;
    border-radius: 6px;
}

.checkbox-item {
    margin-bottom: 6px;
    padding: 6px;
    cursor: pointer;
}

.assign-btn {
    margin-top: 20px;
    padding: 10px 20px;
}
</style>


<h2>Assign Learning Paths to Batches</h2>

<form method="POST">

    <div style="display: flex; gap: 40px;">

        <!-- Learning Paths -->
        <div style="width: 45%;">
            <h4>Learning Paths</h4>
            <div class="lp-box">

                <?php foreach ($learningpaths as $lp): ?>
                    <div class="checkbox-item">
                        <input type="checkbox" name="learningpaths[]" value="<?= $lp->id; ?>">
                        <?= format_string($lp->name); ?>
                    </div>
                <?php endforeach; ?>

            </div>
        </div>


        <!-- Batches -->
        <div style="width: 45%;">
            <h4>Batches</h4>
            <div class="batch-box">

                <?php foreach ($batches as $batch): ?>
                    <div class="checkbox-item">
                        <input type="checkbox" name="batches[]" value="<?= $batch->id; ?>">
                        <?= format_string($batch->name); ?>
                    </div>
                <?php endforeach; ?>

            </div>
        </div>

    </div>

    <button class="btn btn-primary assign-btn" type="submit">Assign</button>

</form>


<?php
echo $OUTPUT->footer();
