<?php
require_once(__DIR__ . '/../../config.php');

require_login();

global $DB, $PAGE, $OUTPUT, $USER;

// Context
$context = context_system::instance();

// Page setup
$PAGE->set_url('/local/custompage/assessment_report.php');
$PAGE->set_context($context);
$PAGE->set_title('My Assessment Report');
$PAGE->set_heading('My Assessment Report');
$PAGE->set_pagelayout('report');

/* ===== DataTables Bootstrap Style (STYLE ONLY) ===== */
$PAGE->requires->css(new moodle_url(
    'https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css'
));
$PAGE->requires->js(new moodle_url(
    'https://code.jquery.com/jquery-3.7.0.min.js'
), true);
$PAGE->requires->js(new moodle_url(
    'https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js'
), true);
$PAGE->requires->js(new moodle_url(
    'https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js'
), true);
/* ===== DataTables Buttons (REQUIRED) ===== */
$PAGE->requires->css(new moodle_url(
    'https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css'
));
$PAGE->requires->js(new moodle_url(
    'https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js'
), true);
$PAGE->requires->js(new moodle_url(
    'https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js'
), true);
$PAGE->requires->js(new moodle_url(
    'https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js'
), true);
$PAGE->requires->js(new moodle_url(
    'https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js'
), true);
$PAGE->requires->js(new moodle_url(
    'https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js'
), true);
$PAGE->requires->js(new moodle_url(
    'https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js'
), true);
$PAGE->requires->js(new moodle_url(
    'https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js'
), true);
/* ======================================= */

/* ================================================ */

echo $OUTPUT->header();
echo $OUTPUT->heading('My Assessment Report');

/**
 * RULES APPLIED:
 * - user enrolled
 * - quiz not deleted
 * - quiz has questions
 * - user has at least one real attempt
 */
$sql = "
SELECT
    q.id AS quizid,
    q.name AS quizname,
    q.timeopen,
    q.timeclose,
    q.attempts AS allowedattempts,
    cm.id AS cmid,
    COUNT(DISTINCT qa.id) AS takenattempts
FROM {quiz} q
JOIN {course_modules} cm
        ON cm.instance = q.id
JOIN {modules} m
        ON m.id = cm.module
       AND m.name = 'quiz'
JOIN {course} c
        ON c.id = q.course
JOIN {enrol} e
        ON e.courseid = c.id
JOIN {user_enrolments} ue
        ON ue.enrolid = e.id
       AND ue.userid = :userid1
JOIN {quiz_slots} qs
        ON qs.quizid = q.id
JOIN {quiz_attempts} qa
        ON qa.quiz = q.id
       AND qa.userid = :userid2
       AND qa.preview = 0
WHERE cm.deletioninprogress = 0
GROUP BY
    q.id, q.name, q.timeopen, q.timeclose, q.attempts, cm.id
ORDER BY q.timecreated DESC
";

$records = $DB->get_records_sql($sql, [
    'userid1' => $USER->id,
    'userid2' => $USER->id
]);

/* ===== TABLE (STYLE ONLY CHANGED) ===== */
echo '<div class="table-responsive">';
echo '<table id="assessmentReportTable" class="table table-striped table-bordered">';
echo '<thead>
<tr>
    <th>S.No</th>
    <th>Assessment Name</th>
    <th>Allowed Attempts</th>
    <th>Taken Attempts</th>
    <th class="text-center">Action</th>
</tr>
</thead>';
echo '<tbody>';

$i = 1;

if (!empty($records)) {
    foreach ($records as $r) {

        $allowed = ($r->allowedattempts == 0)
            ? 'Unlimited'
            : $r->allowedattempts;

      // Get course context (quiz belongs to course)
$coursecontext = context_course::instance($r->courseid ?? $r->courseid = $DB->get_field('quiz','course',['id'=>$r->quizid]));

// Quiz view URL
$returnurl = new moodle_url('/local/custompage/assessment_report.php');

$quizurl = new moodle_url('/mod/quiz/view.php', [
    'id' => $r->cmid,
    'returnurl' => $returnurl->out(false)
]);


// Decide final URL
if (has_capability('moodle/role:switchroles', $coursecontext)) {

    // Manager / Teacher → go via switchrole.php
   $finalurl = new moodle_url('/local/learningpath/switchrole.php', [
    'redirect' => $quizurl->out(false),
    'courseid' => $r->courseid,
    'sesskey'  => sesskey()
]);


} else {

    // Student → direct quiz view
    $finalurl = $quizurl;
}


        echo '<tr>';
        echo '<td></td>';

        echo '<td>' . format_string($r->quizname) . '</td>';
        echo '<td>' . $allowed . '</td>';
        echo '<td>' . (int)$r->takenattempts . '</td>';
       echo '<td class="text-center">
        <a class="btn btn-sm btn-primary" href="' . $finalurl . '">
            View
        </a>
      </td>';

        echo '</tr>';
    }
} 

echo '</tbody></table></div>';
/* ===================================== */

/* ===== DataTables Init (STYLE ONLY) ===== */
/* ===== DataTables Init (STYLE + EXPORT FIXED) ===== */
$PAGE->requires->js_init_code("
$(document).ready(function () {

    var table = $('#assessmentReportTable').DataTable({
        responsive: true,
        pageLength: 10,
        lengthChange: true,
        order: [[1, 'asc']],
        dom: 'Bfrtip',

        buttons: [
           {
    extend: 'excelHtml5',
    title: 'Assessment_Report',
    text: 'Download Excel',
    exportOptions: {
        columns: [0, 1, 2, 3],
        format: {
            body: function (data, row, column, node) {

                // ✅ S.No ONLY FOR EXCEL
                if (column === 0) {
                    return row + 1;
                }

                // ❌ DO NOT TOUCH OTHER COLUMNS
                return data;
            }
        }
    }
}
,
            {
                extend: 'pdfHtml5',
                title: 'Assessment_Report',
                text: 'Download PDF',
                orientation: 'landscape',
                pageSize: 'A4',
                exportOptions: {
                    columns: [0, 1, 2, 3] // ❌ Action removed
                },
                customize: function (doc) {

                    // ✅ FULL WIDTH TABLE
                    doc.content[1].table.widths = ['5%', '45%', '25%', '25%'];

                    var body = doc.content[1].table.body;

                    // ✅ FIX S.No + CENTER ALL ROW DATA
                    for (var i = 1; i < body.length; i++) {
                        body[i][0].text = i.toString(); // S.No
                        body[i].forEach(function (cell) {
                            cell.alignment = 'center';
                        });
                    }

                    // ✅ CENTER + STYLE HEADER
                    body[0].forEach(function (cell) {
                        cell.alignment = 'center';
                        cell.fillColor = '#2c3e50';
                        cell.color = '#ffffff';
                    });

                    // ✅ CLEAN TABLE LAYOUT
                    doc.layout = {
                        hLineWidth: function () { return 0.5; },
                        vLineWidth: function () { return 0; },
                        hLineColor: function () { return '#cccccc'; },
                        paddingLeft: function () { return 6; },
                        paddingRight: function () { return 6; },
                        paddingTop: function () { return 4; },
                        paddingBottom: function () { return 4; }
                    };
                }
            }
        ],

        columnDefs: [
            { orderable: false, targets: [0, 4] } // S.No & Action
        ],

        language: {
    search: 'Search Assessment:',
    lengthMenu: 'Show _MENU_ entries',
    info: 'Showing _START_ to _END_ of _TOTAL_ assessments',
    emptyTable: 'No Assessments Found',
    zeroRecords: 'No Assessments Found'
}

    });

    // ✅ FIX S.No ON SCREEN
    table.on('order.dt search.dt draw.dt', function () {
        let i = 1;
        table.column(0, { search: 'applied', order: 'applied' })
            .nodes()
            .each(function (cell) {
                cell.innerHTML = i++;
            });
    }).draw();

});
");



/* ===================================== */

echo $OUTPUT->footer();
