<?php
require_once(__DIR__ . '/../../config.php');
require_login();

$context = context_system::instance();
require_capability('moodle/site:config', $context);

$PAGE->set_context($context);
$PAGE->set_url('/local/custompage/assessment_admin_report.php');
$PAGE->set_title('Assessment Attempt Report');
$PAGE->set_heading('Assessment Attempt Report');

/* ===================== CSS & JS ===================== */
$PAGE->requires->css(new moodle_url('https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css'));
$PAGE->requires->css(new moodle_url('https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css'));

$PAGE->requires->js(new moodle_url('https://code.jquery.com/jquery-3.7.0.min.js'), true);
$PAGE->requires->js(new moodle_url('https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js'), true);
$PAGE->requires->js(new moodle_url('https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js'), true);

$PAGE->requires->js(new moodle_url('https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js'), true);
$PAGE->requires->js(new moodle_url('https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js'), true);
$PAGE->requires->js(new moodle_url('https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js'), true);
$PAGE->requires->js(new moodle_url('https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js'), true);
$PAGE->requires->js(new moodle_url('https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js'), true);
$PAGE->requires->js(new moodle_url('https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js'), true);

echo $OUTPUT->header();
echo $OUTPUT->heading('Assessment Report');

/* ===================== SQL ===================== */
$sql = "
SELECT
    qa.id               AS attemptid,
    qa.attempt          AS attemptno,
    qa.timemodified     AS attempttime,
    qa.sumgrades        AS attemptsummarks,

    u.id AS userid,
    CONCAT(u.firstname, ' ', u.lastname) AS fullname,
    u.email,
    cpy.com_name AS companyname,

    q.id AS quizid,
    q.name AS quizname,
    q.attempts AS allowedattempts,
    q.sumgrades AS maxmarks,

    qg.grade AS finalgrade,
    gi.gradepass AS gradepass

FROM {quiz_attempts} qa
JOIN {user} u ON u.id = qa.userid
JOIN {quiz} q ON q.id = qa.quiz
LEFT JOIN {quiz_grades} qg ON qg.quiz = q.id AND qg.userid = u.id
LEFT JOIN {grade_items} gi ON gi.itemtype='mod' AND gi.itemmodule='quiz' AND gi.iteminstance=q.id
LEFT JOIN {company} cpy ON cpy.id = u.company_id

WHERE u.deleted = 0
AND qa.preview = 0
AND qa.state = 'finished'

ORDER BY qa.timemodified DESC
";

$recordset = $DB->get_recordset_sql($sql);

/* ===================== TABLE ===================== */
echo '<div class="table-responsive">';
echo '<table id="assessmenttable" class="table table-striped table-bordered">';

echo '<thead>
<tr>
<th>S.No</th>
<th>User Name</th>
<th>Company</th>
<th>Email</th>
<th>Assessment Name</th>
<th>Attempt Taken</th>
<th>Attempt Date</th>
<th>Allowed Attempts</th>
<th>Grade</th>
<th>Result</th>
</tr>
</thead><tbody>';

foreach ($recordset as $r) {

    $company = $r->companyname ? format_string($r->companyname) : '-';
    $allowed = ($r->allowedattempts == 0) ? 'Unlimited' : $r->allowedattempts;
    $attemptdate = userdate($r->attempttime, '%d-%b-%Y %I:%M %p');

    $grade100 = ($r->maxmarks > 0)
        ? format_float(($r->attemptsummarks / $r->maxmarks) * 100, 2)
        : '-';

   $result = ($r->gradepass !== null && $grade100 >= $r->gradepass)
    ? 'Pass' : 'Fail';


    echo '<tr>';
    echo '<td></td>'; // 🔥 EMPTY — DataTables will handle
    echo '<td>'.format_string($r->fullname).'</td>';
    echo '<td>'.$company.'</td>';
    echo '<td>'.s($r->email).'</td>';
    echo '<td>'.format_string($r->quizname).'</td>';
    echo '<td class="text-center">'.$r->attemptno.'</td>';
    echo '<td class="text-center">'.$attemptdate.'</td>';
    echo '<td class="text-center">'.$allowed.'</td>';
    echo '<td class="text-center">'.$grade100.'</td>';
    echo '<td class="text-center">'.$result.'</td>';
    echo '</tr>';
}
$recordset->close();

echo '</tbody></table></div>';


/* ===================== DATATABLE ===================== */
$PAGE->requires->js_init_code("
$(document).ready(function () {

    var table = $('#assessmenttable').DataTable({
        responsive: true,
        pageLength: 10,
        order: [[6, 'desc']], // Attempt Date
        dom: 'Bfrtip',

        buttons: [
            {
                extend: 'excelHtml5',
                title: 'Assessment_Attempt_Report',
                text: 'Download Excel',
                exportOptions: {
                    columns: [0,1,2,3,4,5,6,7,8,9],
                    format: {
                        body: function (data, row, column) {
                            if (column === 0) {
                                return row + 1; // ✅ S.No in Excel
                            }
                            return data;
                        }
                    }
                }
            },
            {
                extend: 'pdfHtml5',
                title: 'Assessment_Attempt_Report',
                text: 'Download PDF',
                orientation: 'landscape',
                pageSize: 'A4',
                customize: function (doc) {
                    var body = doc.content[1].table.body;
                    for (var i = 1; i < body.length; i++) {
                        body[i][0].text = i.toString(); // ✅ S.No in PDF
                    }
                }
            }
        ],

        language: {
            search: 'Search:',
            lengthMenu: 'Show _MENU_ entries',
            info: 'Showing _START_ to _END_ of _TOTAL_ records',
            emptyTable: 'No assessments found',
            zeroRecords: 'No assessments found'
        }
    });

    // ✅ SCREEN S.No
    table.on('order.dt search.dt draw.dt', function () {
        let i = 1;
        table.column(0, { search: 'applied', order: 'applied' })
            .nodes()
            .each(function (cell) {
                cell.innerHTML = i++;
            });
    }).draw();

});
");


echo $OUTPUT->footer();
