<?php
require('../../config.php');
require_once($CFG->dirroot . '/cohort/lib.php');
require_once($CFG->libdir . '/csvlib.class.php');
require_once(__DIR__ . '/local_companycohort_form.php');

require_login();
$context = context_system::instance();

$contextid   = optional_param('contextid', 0, PARAM_INT);
$PAGE->set_url('/local/companycohort/index.php');
$PAGE->set_context($context);
$PAGE->set_title('Create Batch');
$PAGE->set_heading('Create Batch');

$form = new local_companycohort_form();
$errormessage = '';

if ($form->is_cancelled()) {
    redirect(new moodle_url('/cohort/index.php?contextid=1'));
}

elseif ($data = $form->get_data()) {

    global $DB;

    // AUTO GENERATE BATCH ID IF EMPTY
if (empty($data->idnumber)) {
    do {
        $data->idnumber = 'BATCH-' . date('Ymd-His') . '-' . rand(100, 999);
    } while ($DB->record_exists('cohort', ['idnumber' => $data->idnumber]));
}


    // ---------------------------------------------------------
    // 1. CREATE COHORT ENTRY
    // ---------------------------------------------------------
    $cohort = new stdClass();
    $cohort->contextid = $context->id;
    $cohort->name = $data->name;
    $cohort->idnumber = $data->idnumber;
    $cohort->company_id = $data->company_id;
    $cohort->start_date = $data->start_date;
    $cohort->end_date = $data->end_date;
    // $cohort->description = $data->description;
    $cohort->descriptionformat = FORMAT_HTML;
    $cohort->visible = 1;
    $cohort->timecreated = time();
    $cohort->timemodified = time();



// Check if idnumber (batch id) already exists
if ($DB->record_exists('cohort', ['idnumber' => $data->idnumber])) {
    $errormessage = "Batch ID already exists. Please use a unique ID.";
} else {
    // Insert cohort only when unique
    $cohortid = $DB->insert_record('cohort', $cohort);



// Insert cohort
//$cohortid = $DB->insert_record('cohort', $cohort);

   // $cohortid = $DB->insert_record('cohort', $cohort);
    if (!empty($data->selectedusers)) 
    { 
        $ids = explode(',', $data->selectedusers); 
        foreach ($ids as $uid) 
        { 
            if (!$DB->record_exists('cohort_members', ['cohortid'=>$cohortid,'userid'=>$uid])) 
            { 
                $member = new stdClass(); 
                $member->cohortid = $cohortid; 
                $member->userid = $uid; 
                $member->timeadded = time(); 
                $DB->insert_record('cohort_members', $member); 
            } 
        } 
    }
    // ---------------------------------------------------------
    // 2. PROCESS CSV UPLOAD
    // ---------------------------------------------------------
    // ---------------------------------------------------------
// 2. PROCESS CSV UPLOAD  (ONLY IF BULK UPLOAD SELECTED)
// ---------------------------------------------------------
if ($data->usermode == 2) {

    if (empty($data->csvfile)) {
        throw new moodle_exception('csvfilenotfound', 'error');
    }

    $content = $form->get_file_content('csvfile');

    if (!$content) {
        throw new moodle_exception('csvfilenotfound', 'error');
    }

    $iid = csv_import_reader::get_new_iid('uploadusers');
    $cir = new csv_import_reader($iid, 'uploadusers');

    $readcount = $cir->load_csv_content($content, 'utf-8', ',');

    if ($readcount === false) {
        throw new moodle_exception('csvloaderror', 'error');
    }

    $columns = $cir->get_columns();

    if (empty($columns)) {
        throw new moodle_exception('invalidcsv', 'error');
    }

    $cir->init();

    while ($row = $cir->next()) {

        $data = array_combine($columns, $row);

        $email = trim($data['email']);
        $firstname = trim($data['firstname']);
        $lastname = trim($data['lastname']);

        if (empty($email)) {
    $errormessage = 'Email is compulsory in CSV file.';
   continue;
}


    // ❌ Invalid email format → skip row
    if (!validate_email($email)) {
        $errormessage = 'Some users were skipped because email is missing or invalid.';
        continue;
    }


        if (!$DB->record_exists('user', ['email' => $email])) {

            $user = new stdClass();
            $user->auth = 'manual';
            $user->email = $email;
            $user->username = $email;
            $user->firstname = $firstname;
            $user->lastname = $lastname;
            $user->password = hash_internal_user_password('Temp@123');
            $user->confirmed = 1;
            $user->mnethostid = $CFG->mnet_localhost_id;
            $user->company_id = $cohort->company_id;




            $userid = $DB->insert_record('user', $user);
               $studentrole = 5; // Student role id
    $syscontext = context_system::instance();
    role_assign($studentrole, $userid, $syscontext->id);
$to = $DB->get_record('user', ['id' => $userid]);
$from = core_user::get_support_user();

$subject = "Welcome to Trainocate ($firstname)";

$text = "Hi {$firstname},

Welcome to Trainocate. Your account has been created successfully.

URL: {$CFG->wwwroot}
Username: {$email}
Password: Temp@123

Login here:
{$CFG->wwwroot}/login/index.php

Thanks,
Trainocate Team";

$html = '
<div style="max-width:600px;margin:auto;border:1px solid #ddd;border-radius:6px;font-family:Arial, sans-serif;">
    <div style="background:#e74c3c;padding:15px;border-radius:6px 6px 0 0;">
        <h2 style="margin:0;color:white;font-size:20px;">Welcome to Trainocate Portal</h2>
    </div>

    <div style="padding:20px;font-size:15px;color:#333;">
        <p>Hi <strong>'.$firstname.'</strong>,</p>

        <p>Welcome to Trainocate. Your account has been created successfully.<br>
        Please find your credentials below:</p>

       

        <p><strong>Username:</strong> '.$email.'</p>
        <p><strong>Password:</strong> Temp@123</p>

        <p>You can log in using the link below:</p>

        <p>
            <a href="'.$CFG->wwwroot.'/login/index.php" 
               style="color:#0066cc;word-break:break-all;">
                '.$CFG->wwwroot.'/login/index.php
            </a>
        </p>

        <p>Thanks,<br>Trainocate Team</p>
    </div>
</div>';

email_to_user($to, $from, $subject, $text, $html);


        } else {
            $existing = $DB->get_record('user', ['email' => $email]);
            $userid = $existing->id;
        }

        cohort_add_member($cohortid, $userid);
    }

    $cir->cleanup();
    $cir->close();
}


    redirect(new moodle_url('/cohort/index.php'), "Batch created successfully!", 2);
}
}
echo $OUTPUT->header();
if ($contextid) {
    // When inside a specific context (e.g., cohort context)
    echo $OUTPUT->heading('Create New Batch');
} 

// ✅ Show same cohort navigation tabs (All batches / Add new batch / Upload batches / Bulk user with batch)
$currenturl = $PAGE->url;

$allbatchesurl = new moodle_url('/cohort/index.php', ['contextid' => $context->id]);
$addbatchurl = new moodle_url('/local/companycohort/index.php', ['contextid' => $context->id]); // your page
$uploadbatchesurl = new moodle_url('/cohort/upload.php', ['contextid' => $context->id]);
$uploadbatchusersurl = new moodle_url('/admin/tool/uploaduser/index.php', ['contextid' => $context->id]);

// ✅ Define tab structure
$tabs = [];
$tabs[] = new tabobject('allbatches', $allbatchesurl, 'All batches');
$tabs[] = new tabobject('addbatch', $addbatchurl, 'Add new batch');
$tabs[] = new tabobject('uploadbatches', $uploadbatchesurl, 'Upload batches');

// ✅ Detect which tab is active
$currenttab = '';
if ($currenturl->get_path() === $allbatchesurl->get_path()) {
    $currenttab = 'allbatches';
} else if ($currenturl->get_path() === $addbatchurl->get_path()) {
    $currenttab = 'addbatch';
} else if ($currenturl->get_path() === $uploadbatchesurl->get_path()) {
    $currenttab = 'uploadbatches';
} else if ($currenturl->get_path() === $uploadbatchusersurl->get_path()) {
    $currenttab = 'uploadbatchusers';
}

// ✅ Display tabs
echo $OUTPUT->tabtree($tabs, $currenttab);
if (!empty($errormessage)) {
    echo html_writer::div($errormessage, 'alert alert-danger');
}

$form->display();
echo $OUTPUT->footer();
