<?php

namespace local_qbankmanager;

defined('MOODLE_INTERNAL') || die();

class custombank extends \core_question\local\bank\view {

    protected function print_table($questions): void {
        global $OUTPUT, $DB;

        echo '<div class="card mt-3">
                <div class="table-responsive">
                  <table class="table table-striped align-middle mb-0">
                    <thead class="table-light">
                      <tr>
                        <th>S.No</th>
                        <th>Category</th>
                        <th>Question type</th>
                        <th>Created On</th>
                        <th class="text-center">Action</th>
                      </tr>
                    </thead>
                    <tbody>';

        if ($questions) {
            $i = 1;

            foreach ($questions as $q) {

                // -------- Category name ----------
                $catname = '-';

                // Moodle sometimes stores category in different fields
                $catid = $q->questioncategoryid
                    ?? ($q->categoryid ?? ($q->category ?? 0));

                if ($catid && ($qcat = $DB->get_record('question_categories', ['id' => $catid]))) {

                    // if mapped to course category (coursecat_X)
                    if (!empty($qcat->idnumber) && strpos($qcat->idnumber, 'coursecat_') === 0) {

                        $coursecatid = (int) str_replace('coursecat_', '', $qcat->idnumber);

                        if ($coursecat = $DB->get_record('course_categories', ['id' => $coursecatid])) {
                            $catname = $coursecat->name;
                        }

                    } else {
                        $catname = $qcat->name;
                    }
                }

                echo '<tr>
                        <td>' . $i++ . '</td>
                        <td>' . format_string($catname) . '</td>
                        <td>' . ucfirst($q->qtype) . '</td>
                        <td>' . userdate($q->timecreated, "%d %B %Y") . '</td>
                        <td class="text-center">';

                // -------- EDIT --------
                $editurl = new \moodle_url('/question/bank/editquestion/question.php', [
                    'id' => $q->id,
                    'cmid' => $this->cm->id,
                    'returnurl' => $this->base_url()->out_as_local_url(false)
                ]);

                echo \html_writer::link(
                    $editurl,
                    $OUTPUT->pix_icon('t/edit', get_string('edit')),
                    ['class' => 'btn btn-link p-1', 'title' => get_string('edit')]
                );

                // -------- PREVIEW --------
                $previewurl = new \moodle_url('/question/bank/previewquestion/preview.php', [
                    'id' => $q->id,
                    'restartversion' => 0,
                    'cmid' => $this->cm->id,
                    'returnurl' => (new \moodle_url('/local/qbankmanager/index.php',
                        ['cmid' => $this->cm->id]))->out_as_local_url(false)
                ]);

                echo \html_writer::link(
                    $previewurl,
                    $OUTPUT->pix_icon('t/preview', get_string('preview')),
                    ['class' => 'btn btn-link p-1', 'title' => get_string('preview')]
                );

                // -------- DELETE --------
                $deleteurl = new \moodle_url('/question/bank/deletequestion/delete.php', [
                    'deleteselected' => $q->id,
                    'q' . $q->id => 1,
                    'sesskey' => sesskey(),
                    'cmid' => $this->cm->id,
                    'courseid' => $this->course->id,
                    'returnurl' => (new \moodle_url('/local/qbankmanager/index.php',
                        ['cmid' => $this->cm->id]))->out_as_local_url(false)
                ]);

                echo \html_writer::link(
                    $deleteurl,
                    $OUTPUT->pix_icon('t/delete', get_string('delete')),
                    ['class' => 'btn btn-link p-1', 'title' => get_string('delete')]
                );

                echo '</td></tr>';
            }

        } else {
            echo '<tr>
                    <td colspan="5" class="text-center text-muted">
                        No Questions Found
                    </td>
                  </tr>';
        }

        echo '      </tbody>
                  </table>
                </div>
              </div>';
    }
}
