<?php
require_once(__DIR__ . '/../../config.php');
require_login();
require_sesskey();

global $DB, $USER;

$context = context_system::instance();
require_capability('moodle/site:config', $context);

$id           = required_param('id', PARAM_INT);
$categoryid   = required_param('category_id', PARAM_INT);
$name         = required_param('name', PARAM_TEXT);
$slug         = optional_param('slug', '', PARAM_TEXT);
$sku          = optional_param('sku', '', PARAM_TEXT);
$types        = optional_param_array('type', [], PARAM_TEXT);
$level        = optional_param('level', '', PARAM_TEXT);
$status       = optional_param('status', 'Unpublish', PARAM_TEXT);
$structure    = optional_param('structure_json', '', PARAM_RAW);

if (!$name) {
    print_error('invaliddata', 'error', '', 'Learning path name is required');
}

/*
 * MAP SECTION TYPE STRINGS -> INTEGER CODES
 */
$TYPE_MAP = [
    'aws'      => 1,
    'practice' => 2,
    'online'   => 3,
    'lab'      => 4,
    'reading'  => 5
];

/* MAIN RECORD */
$record = (object)[
    'categoryid'   => $categoryid,
    'name'         => $name,
    'slug'         => $slug,
    'sku'          => $sku,
    'type'         => implode(',', $types),
    'level'        => $level,
    'status'       => $status,
    'timemodified' => time()
];

if ($id == 0) {
    $record->timecreated = time();
    $record->createdby   = $USER->id;
    $pathid = $DB->insert_record('learning_paths', $record);
} else {
    $record->id = $id;
    $DB->update_record('learning_paths', $record);
    $pathid = $id;
}

/* STRUCTURE JSON */
$data = json_decode($structure, true);
if (!is_array($data)) $data = [];

/* EXISTING SECTIONS */
$existing     = $DB->get_records('learning_path_sections', ['learningpathid' => $pathid]);
$existing_ids = array_keys($existing);
$submitted_ids = [];

/* LOOP SECTIONS */
foreach ($data as $i => $section) {

    $sectionid = intval($section['id'] ?? 0);

    $typekey     = $section['type'] ?? '';
    $sectiontype = $TYPE_MAP[$typekey] ?? 0;

    if ($sectiontype === null) {
    $sectiontype = 0;
}

    $sec = (object)[
        'learningpathid' => $pathid,
        'sectionname'    => trim($section['title'] ?? ('Section '.($i+1))),
        'sectiontype'    => $sectiontype,
        'position'       => $i + 1,
        'timemodified'   => time()
    ];

    if ($sectionid && isset($existing[$sectionid])) {
        $sec->id = $sectionid;
        $DB->update_record('learning_path_sections', $sec);
    } else {
        $sectionid = $DB->insert_record('learning_path_sections', $sec);
    }

    $submitted_ids[] = $sectionid;

    /* RESET ACTIVITIES */
    $DB->delete_records('learning_path_courses', ['sectionid' => $sectionid]);

    if (!empty($section['items']) && is_array($section['items'])) {

        $sort = 1;

     foreach ($section['items'] as $item) {

    $c = (object)[
        'sectionid'    => $sectionid,
        'sortorder'    => $sort++,
        'timemodified' => time()
    ];

    if (!empty($item['type']) && $item['type'] === 'quiz') {
        $c->activitytype = 'quiz';
        $c->quizid       = (int)$item['id'];
        $c->courseid     = null;
    } else {
        $c->activitytype = 'course';
        $c->courseid     = (int)$item['id'];
        $c->quizid       = null;
    }

    $DB->insert_record('learning_path_courses', $c);
}

    }
}

/* REMOVE DELETED SECTIONS */
$delete = array_diff($existing_ids, $submitted_ids);
if ($delete) {
    list($sql, $p) = $DB->get_in_or_equal($delete);
    $DB->delete_records_select('learning_path_courses', "sectionid $sql", $p);
    $DB->delete_records_select('learning_path_sections', "id $sql", $p);
}

redirect(
    new moodle_url('/local/learningpath/manage.php'),
    ($id == 0 ? 'Created Successfully.' : 'Updated Successfully.'),
    2
);
