<?php
require_once(__DIR__ . '/../../config.php');
require_login();
global $DB, $USER;

require_sesskey();
$context = context_system::instance();
require_capability('moodle/site:config', $context);

// basic params
$categoryid = required_param('category_id', PARAM_INT);
$name = required_param('name', PARAM_TEXT);
$slug = optional_param('slug', '', PARAM_TEXT);
$sku = optional_param('sku', '', PARAM_TEXT);
$types = optional_param_array('type', [], PARAM_TEXT);
$level = optional_param('level', '', PARAM_TEXT);
$status = optional_param('status', 'Unpublish', PARAM_TEXT);
$structure_json = required_param('structure_json', PARAM_RAW);

// save image if uploaded (optional): skipped here - store filename or URL if needed
$image = '';

// insert learning path
$record = new stdClass();
$record->categoryid = $categoryid;
$record->name = $name;
$record->slug = $slug;
$record->sku = $sku;
$record->type = implode(',', $types);
$record->image = $image;
$record->level = $level;
$record->status = $status;
$record->timecreated = time();
$record->timemodified = time();
$record->createdby = $USER->id;

$pathid = $DB->insert_record('learning_paths', $record);

// parse structure JSON
$data = json_decode($structure_json, true);
if (!empty($data['sections']) && $pathid) {
    foreach ($data['sections'] as $section) {
        $sec = new stdClass();
        $sec->learningpathid = $pathid;
        $sec->sectionname = $section['name'];
        $sec->position = isset($section['position']) ? intval($section['position']) : 0;
        $sec->timemodified = time();
        $sectionid = $DB->insert_record('learning_path_sections', $sec);

        // insert courses in order
        if (!empty($section['courses'])) {
            $order = 1;
            foreach ($section['courses'] as $cid) {
                $c = new stdClass();
                $c->sectionid = $sectionid;
                $c->courseid = intval($cid);
                $c->sortorder = $order++;
                $c->timemodified = time();
                $DB->insert_record('learning_path_courses', $c);
            }
        }
    }
}

redirect(new moodle_url('/local/learningpath/manage.php'), 'Learning Path created successfully');
