<?php
require_once(__DIR__ . '/../../config.php');
require_login();
global $DB, $OUTPUT, $PAGE;

$context = context_system::instance();
require_capability('moodle/site:config', $context);

$PAGE->set_url(new moodle_url('/local/learningpath/manage.php'));
$PAGE->set_context($context);
$PAGE->set_title('Learning Path Management');
$PAGE->set_heading('Learning Path Management');

// ---------------------
// DELETE LOGIC
// ---------------------
$deleteid = optional_param('delete', 0, PARAM_INT);
$confirm  = optional_param('confirm', 0, PARAM_BOOL);

if ($deleteid) {
    $path = $DB->get_record('learning_paths', ['id' => $deleteid], '*', IGNORE_MISSING);

    if (!$path) {
        print_error('Invalid Learning Path');
    }

    if ($confirm) {
        $DB->delete_records('learning_paths', ['id' => $deleteid]);

        redirect(
            new moodle_url('/local/learningpath/manage.php'),
            "Learning Path deleted successfully!",
            null,
            \core\output\notification::NOTIFY_SUCCESS
        );
    }

    echo $OUTPUT->header();
    echo $OUTPUT->confirm(
        "Are you sure you want to delete: <strong>" . format_string($path->name) . "</strong> ?",
        new moodle_url('/local/learningpath/manage.php', ['delete' => $deleteid, 'confirm' => 1]),
        new moodle_url('/local/learningpath/manage.php')
    );
    echo $OUTPUT->footer();
    exit;
}
// ---------------------
// END DELETE LOGIC
// ---------------------

// Filters
$categoryid = optional_param('categoryid', 0, PARAM_INT);
$name = optional_param('name', '', PARAM_TEXT);

// Pagination
$page     = optional_param('page', 0, PARAM_INT);
$perpage  = 10;
$start    = $page * $perpage;

// Fetch categories
$categories = $DB->get_records_menu('course_categories', null, 'name ASC', 'id, name');

// Build WHERE
$where = '1=1';
$params = [];

if ($categoryid) {
    $where .= ' AND categoryid = :cat';
    $params['cat'] = $categoryid;
}
if (!empty($name)) {
    $where .= ' AND name LIKE :nm';
    $params['nm'] = "%$name%";
}

// Count total for pagination
$totalpaths = $DB->count_records_select('learning_paths', $where, $params);

// Fetch paginated records
$learningpaths = $DB->get_records_select(
    'learning_paths',
    $where,
    $params,
    'id DESC',
    '*',
    $start,
    $perpage
);

echo $OUTPUT->header();
?>

<div class="container-fluid mt-4">

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="fw-bold text-primary">List of Learning Paths</h3>

    <a href="create.php" class="btn btn-primary">
        <?php echo $OUTPUT->pix_icon('t/add', 'Add'); ?> Add New Learning Path
    </a>
  </div>

<!-- Filters -->
<form method="get" class="card mb-4 p-3">
    <div class="row g-2 align-items-center">

        <!-- Category -->
        <div class="col-md-3">
            <select name="categoryid" class="form-select filter-input">
                <option value="">Select Category</option>
                <?php foreach ($categories as $id => $catname): ?>
                    <option value="<?= $id ?>" <?= $categoryid == $id ? 'selected' : '' ?>>
                        <?= format_string($catname) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <!-- Name -->
        <div class="col-md-5">
            <input type="text"
                   name="name"
                   class="form-control filter-input"
                   value="<?= s($name) ?>"
                   placeholder="Enter name">
        </div>

        <!-- Search button -->
        <div class="col-md-4 d-grid">
            <button type="submit" class="btn btn-orange filter-btn">
                <?= $OUTPUT->pix_icon('a/search', 'Search'); ?> Search
            </button>
        </div>

    </div>
</form>
<style>
    .filter-input {
        height: 45px;
        border-radius: 8px;
    }

    .filter-btn {
        height: 45px;
        background-color: #ff5b00;
        color: #fff;
        font-weight: 600;
        border-radius: 8px;
    }

    .filter-btn:hover {
        background-color: #e44a00;
        color: #fff;
    }
</style>




  <!-- Table -->
  <div class="card">
    <div class="table-responsive">
      <table class="table table-striped align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th>S.No</th>
            <th>Name</th>
            <th>Category</th>
            <th>Level</th>
            <th>Status</th>
            <th>Created On</th>
            <th class="text-center">Action</th>
          </tr>
        </thead>
        <tbody>

          <?php if ($learningpaths): 
            $i = $start + 1;
            foreach ($learningpaths as $path): ?>
              <tr>
                <td><?= $i++ ?></td>
                <td><?= format_string($path->name) ?></td>
                <td><?= $categories[$path->categoryid] ?? '-' ?></td>
                <td><?= format_string($path->level) ?></td>
                <td><?= format_string($path->status) ?></td>

                <!-- Only Date, Month, Year -->
                <td><?= userdate($path->timecreated, '%d %B %Y') ?></td>

                <td class="text-center">

                    <!-- Edit -->
                    <a href="edit.php?id=<?= $path->id ?>" 
                       class="btn btn-link p-1" title="Edit">
                        <?= $OUTPUT->pix_icon('t/edit', 'Edit'); ?>
                    </a>

          <!-- View -->
<!-- <a href="learner_path_view.php?id=<?= $path->id ?>" 
   class="btn btn-link p-1" title="View">
    <?= $OUTPUT->pix_icon('t/preview', 'View'); ?>
</a> -->




                    <!-- Report -->
                    <a href="manage_detail.php?id=<?= $path->id ?>" 
                       class="btn btn-link p-1" title="Report">
                        <?= $OUTPUT->pix_icon('i/report', 'Report'); ?>
                    </a>

                    <!-- Delete -->
                    <a href="?delete=<?= $path->id ?>" 
                       class="btn btn-link p-1" 
                       title="Delete"
                      >
                        <?= $OUTPUT->pix_icon('t/delete', 'Delete'); ?>
                    </a>

                </td>
              </tr>
            <?php endforeach;
          else: ?>
            <tr><td colspan="7" class="text-center text-muted">No Learning Paths Found</td></tr>
          <?php endif; ?>

        </tbody>
      </table>
    </div>

    <!-- Pagination -->
    <div class="p-3">
      <?php
        echo $OUTPUT->paging_bar(
            $totalpaths,
            $page,
            $perpage,
            new moodle_url('/local/learningpath/manage.php', [
                'categoryid' => $categoryid,
                'name'       => $name
            ])
        );
      ?>
    </div>

  </div>
</div>

<?php
echo $OUTPUT->footer();
