<?php
// File: local/learningpath/learner_path_view.php
require_once('../../config.php');
require_login();

global $DB, $USER, $PAGE, $OUTPUT, $CFG;

$pathid = required_param('id', PARAM_INT);

$PAGE->set_url(new moodle_url('/local/learningpath/learner_path_view.php', ['id' => $pathid]));
$PAGE->set_context(context_system::instance());

// include CSS
$cssfile = new moodle_url('/local/learningpath/learner_styles.css');
$PAGE->requires->css($cssfile);

// fetch learning path
$lp = $DB->get_record('learning_paths', ['id' => $pathid], '*', MUST_EXIST);

// fetch sections ordered by position
$sections = $DB->get_records('learning_path_sections', ['learningpathid' => $pathid], 'position ASC');

$PAGE->set_title(format_string($lp->name));
$PAGE->set_heading(format_string($lp->name));

echo $OUTPUT->header();


// 🔙 Back button
$backurl = new moodle_url('/local/custompage/training2.php');

echo '<div style="margin-bottom:10px; text-align:right;">
        <a href="'.$backurl->out(false).'" class="btn btn-secondary">
            ← Back
        </a>
      </div>';


echo '<div class="lp-container">';

// header / hero
echo '<div class="lp-hero">';

echo '<div>';
echo '<div class="title">' . format_string($lp->name) . '</div>';
echo '<div class="sub">' . ($lp->description ? format_text($lp->description, FORMAT_HTML) : '') . '</div>';
echo '</div>';

echo '<div style="text-align:right"></div>';
echo '</div>'; // hero

// Tabs
echo '<div class="lp-tabs" id="lpTabs">';
$idx = 0;
foreach ($sections as $s) {
    $name = $s->sectionname ? $s->sectionname : 'Section ' . ($idx + 1);
    echo '<div class="lp-tab ' . ($idx===0 ? 'active' : '') . '" data-id="' . $s->id . '">' . format_string($name) . '</div>';
    $idx++;
}
echo '</div>';

// Section contents
$idx = 0;
foreach ($sections as $s) {

    // fetch courses in this section ordered
    $courses = $DB->get_records('learning_path_courses', ['sectionid' => $s->id], 'sortorder ASC');

    // ****** UNLOCKED ALWAYS ******
    $section_unlocked = true;   // <-- ALWAYS TRUE
    // *****************************

    $display_style = ($idx === 0) ? '' : 'style="display:none"';
    echo '<div id="section_content_' . $s->id . '" class="section-wrap" ' . $display_style . '>';

    // compute progress
    $total = count($courses);
    $completed = 0;
    foreach ($courses as $c) {
        $cc = $DB->get_record('course_completions', ['userid' => $USER->id, 'course' => $c->courseid]);
        if ($cc && !empty($cc->timecompleted)) $completed++;
    }
    $secpct = ($total > 0) ? intval(($completed / $total) * 100) : 100;

    echo '<div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:12px">';
  //  echo '<div><strong>' . format_string($s->sectionname) . '</strong></div>';
    echo '<div style="display:flex;align-items:center;gap:10px">';

    // ****** NO LOCK BADGE ANYMORE ******
    if ($total > 0 && $completed === $total) {
        echo '<div class="completed-badge">Completed</div>';
    }
    // ************************************

    echo '</div></div>';

    // courses list
    if (empty($courses)) {
        echo '<div class="card p-3">No courses in this section.</div>';
    } else {
        foreach ($courses as $c) {

            $cc = $DB->get_record('course_completions', ['userid' => $USER->id, 'course' => $c->courseid]);
            $iscompleted = ($cc && !empty($cc->timecompleted));
          $courseurl = new moodle_url('/course/view.php', [
    'id'   => $c->courseid,
    'lpid' => $pathid
]);

            // ****** BUTTON ALWAYS ENABLED ******
            $btnclass = 'course-start';
            $btndisabled = false;
            // ***********************************

           // 🔥 DYNAMIC STATUS BADGE (Reads from local_ltiprogress)
$statusraw = $DB->get_field_sql("
    SELECT lp.activityprogress
      FROM {local_ltiprogress} lp
     WHERE lp.userid = :uid
       AND lp.ltiid  = :cid
  ORDER BY lp.timemodified DESC, lp.timecreated DESC
     LIMIT 1
", [
    'uid' => $USER->id,
    'cid' => $c->courseid
]);

// Default if no record
$statusraw = $statusraw ? trim($statusraw) : 'Not Started';

// Normalize
$label = strtolower($statusraw);

// Decide badge (EXACT mapping)
switch ($label) {

    case 'completed':
        $status      = 'Completed';
        $statusclass = 'completed-badge';
        break;

    case 'in progress':
    case 'inprogress':
        $status      = 'In Progress';
        $statusclass = 'progress-badge';
        break;

    case 'started':
        $status      = 'Started';
        $statusclass = 'started-badge';
        break;

    default:
        $status      = 'Not Started';
        $statusclass = 'notstarted-badge';
        break;
}

$statusbadge = '<div class="' . $statusclass . '">' . $status . '</div>';



            $initials = htmlspecialchars(substr($DB->get_field('course', 'fullname', ['id' => $c->courseid]), 0, 2));

            echo '<div class="course-row">';
            echo '  <div class="course-left">';
           // echo '    <div class="course-thumb">' . $initials . '</div>';
            echo '    <div class="course-meta">';
            echo '      <h4>' . format_string($DB->get_field('course', 'fullname', ['id' => $c->courseid])) . '</h4>';
            $summary = $DB->get_field('course', 'summary', ['id' => $c->courseid]);
            echo '      <p>' . ($summary ? strip_tags(format_text($summary, FORMAT_HTML)) : '&nbsp;') . '</p>';
            echo '    </div>';
            echo '  </div>';

            echo '  <div style="display:flex;align-items:center;gap:12px">';
            echo $statusbadge;
            echo '<a class="course-start" href="' . $courseurl->out(false) . '">' . ($iscompleted ? 'View' : 'Start') . '</a>';
            echo '  </div>';

            echo '</div>';
        }
    }

    echo '</div>'; // section wrap
    $idx++;
}

echo '</div>'; // container

// JS
$js = <<<JS
(function(){
  var tabs = document.querySelectorAll('.lp-tab');
  if (!tabs) return;
  tabs.forEach(function(tab){
    tab.addEventListener('click', function(){
      var id = this.getAttribute('data-id');
      tabs.forEach(t=>t.classList.remove('active'));
      this.classList.add('active');
      document.querySelectorAll('[id^="section_content_"]').forEach(el => el.style.display = 'none');
      var show = document.getElementById('section_content_' + id);
      if (show) show.style.display = '';
    });
  });
})();
JS;

$PAGE->requires->js_init_code($js);

echo $OUTPUT->footer();
exit;
