<?php
require_once(__DIR__ . '/../../config.php');
require_login();
require_sesskey();

global $DB;

$type       = optional_param('type', '', PARAM_ALPHA);
$term       = optional_param('term', '', PARAM_RAW);
$categoryid = optional_param('category', 0, PARAM_INT);   // 👈 global category
$language   = optional_param('language', '', PARAM_TEXT);

$params = [];
$results = [];

/* =========================================================
   PRACTICE TEST (QUIZZES)
========================================================= */
if ($type === 'practice') {

    $sql = "
        SELECT q.id, q.name AS fullname
        FROM {quiz} q
        JOIN {course} c ON c.id = q.course
        WHERE 1 = 1
    ";

    if ($categoryid) {
        $sql .= " AND c.category = :category";
        $params['category'] = $categoryid;
    }

    if ($term) {
        $sql .= " AND q.name LIKE :term";
        $params['term'] = '%' . $DB->sql_like_escape($term) . '%';
    }

    if ($language) {
        $sql .= " AND c.lang = :lang";
        $params['lang'] = $language;
    }

    $sql .= " ORDER BY q.name ASC LIMIT 50";

    $records = $DB->get_records_sql($sql, $params);

    foreach ($records as $r) {
        $results[] = [
            'id'       => $r->id,
            'fullname' => format_string($r->fullname),
            'type'     => 'quiz'
        ];
    }
}

/* =========================================================
   COURSES (default)
========================================================= */
else {

    $sql = "
        SELECT id, fullname
        FROM {course}
        WHERE id > 1
    ";

    if ($categoryid) {
        $sql .= " AND category = :category";
        $params['category'] = $categoryid;
    }

    if ($term) {
        $sql .= " AND fullname LIKE :term";
        $params['term'] = '%' . $DB->sql_like_escape($term) . '%';
    }

    if ($language) {
        $sql .= " AND lang = :lang";
        $params['lang'] = $language;
    }

    $sql .= " ORDER BY fullname ASC LIMIT 50";

    $records = $DB->get_records_sql($sql, $params);

    foreach ($records as $r) {
        $results[] = [
            'id'       => $r->id,
            'fullname' => format_string($r->fullname),
            'type'     => 'course'
        ];
    }
}

echo json_encode($results);
die;
