<?php
// /local/learningpath/create2.php
require_once(__DIR__ . '/../../config.php');
require_login();

global $DB, $PAGE, $OUTPUT;

$context = context_system::instance();
require_capability('moodle/site:config', $context);

/* =========================================================
   AJAX → UNIQUE LEARNING PATH NAME CHECK
========================================================= */
if (optional_param('ajax', 0, PARAM_BOOL)) {
    require_sesskey();
    $name = required_param('name', PARAM_TEXT);
    $exists = $DB->record_exists('learning_paths', ['name' => $name]);
    echo json_encode(['exists' => $exists]);
    exit;
}

/* =========================================================
   PAGE SETUP
========================================================= */
$PAGE->set_context($context);
$PAGE->set_url(new moodle_url('/local/learningpath/create2.php'));
$PAGE->set_title('Create Learning Path');
$PAGE->set_heading('Create Learning Path');

/* =========================================================
   DATA
========================================================= */
$categories = $DB->get_records('course_categories', null, 'name ASC');

$rawlangs = $DB->get_records_sql_menu("
    SELECT DISTINCT lang AS id, lang
    FROM {course}
    WHERE lang IS NOT NULL AND lang <> ''
    ORDER BY lang ASC
");

$langnames = [
    'ar-SA'=>'Arabic (Saudi Arabia)','de-DE'=>'German (Germany)','en-US'=>'English (US)',
    'es-419'=>'Spanish (Latin America)','es-ES'=>'Spanish (Spain)','fr-FR'=>'French',
    'id-ID'=>'Indonesian','it-IT'=>'Italian','ja-JP'=>'Japanese','ko-KR'=>'Korean',
    'pt-BR'=>'Portuguese (Brazil)','zh-CN'=>'Chinese (Simplified)','zh-TW'=>'Chinese (Traditional)',
    'th-TH'=>'Thai','vi-VN'=>'Vietnamese','he-IL'=>'Hebrew','el-GR'=>'Greek',
    'pl-PL'=>'Polish','tr-TR'=>'Turkish','uk-UA'=>'Ukrainian'
];

echo $OUTPUT->header();
?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-rc.0/css/select2.min.css"/>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>

<div class="container-fluid">
  <div class="card shadow-sm p-4 mb-4">

    <div class="d-flex justify-content-between mb-3">
      <h4>Create Learning Path</h4>
      <a href="manage.php" class="btn btn-outline-secondary btn-sm">Back</a>
    </div>

    <form id="lpCreateForm" method="post" action="update2.php" enctype="multipart/form-data">
      <input type="hidden" name="sesskey" value="<?= sesskey() ?>">
      <input type="hidden" name="id" value="0">
      <input type="hidden" name="structure_json" id="structure_json">

      <!-- GLOBAL CATEGORY (used for ALL sections) -->
      <div class="mb-3">
        <label class="form-label"><strong>Category</strong></label>
        <select id="categorySelect" name="category_id" class="form-control" required>
          <option value="">Select Category</option>
          <?php foreach ($categories as $cat): ?>
            <option value="<?= $cat->id ?>"><?= format_string($cat->name) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <!-- Learning Path Details -->
      <div class="card bg-light p-3 mb-3">
        <h5>Learning Path Details</h5>

        <div class="mb-2">
          <label class="form-label">Name</label>
          <input type="text" name="name" id="lp_name" class="form-control" required>
          <div id="lp_name_error" class="text-danger small d-none">
            Learning Path name already exists
          </div>
        </div>

        <div class="row g-2">
          <div class="col-md-6">
            <label class="form-label">Image</label>
            <input type="file" name="image" class="form-control">
          </div>
          <div class="col-md-6">
            <label class="form-label">Level</label>
            <select name="level" class="form-control">
              <option>Beginner</option>
              <option>Intermediate</option>
              <option>Advanced</option>
            </select>
          </div>
        </div>
      </div>

      <!-- Sections -->
      <div class="card bg-light p-3 mb-3">
        <h5>Sections</h5>

        <div id="sectionsContainer">

          <div class="section-item p-3 mb-3 border">

            <!-- SECTION TYPE -->
            <div class="mb-2">
              <strong>Section Type <span class="text-danger">*</span></strong><br>

              <?php
              $types = [
                'aws'      => 'AWS Digital Course',
                'practice' => 'Practice Test',
                'online'   => 'Online Course',
                'lab'      => 'Lab',
                'reading'  => 'Reading Material'
              ];
              foreach ($types as $k => $v):
              ?>
                <div class="form-check form-check-inline">
                  <input class="form-check-input section-type" type="radio" name="section_type_0" value="<?= $k ?>">
                  <label class="form-check-label"><?= $v ?></label>
                </div>
              <?php endforeach; ?>
            </div>

            <div class="d-flex justify-content-between align-items-center mb-2">
              <strong contenteditable="true" class="section-title">Section 1</strong>
              <div>
                <button type="button" class="btn btn-xs btn-outline-primary add-activity">+ Add Activity</button>
                <button type="button" class="btn btn-xs btn-outline-danger remove-section">×</button>
              </div>
            </div>

            <ul class="list-group course-list"></ul>

          </div>
        </div>

        <button type="button" id="addSectionBtn" class="btn btn-primary mt-2">
          Add Heading
        </button>
      </div>

      <div class="mb-3">
        <label>Status</label>
        <select name="status" class="form-control">
          <option>Publish</option>
          <option>Unpublish</option>
        </select>
      </div>

      <div class="text-end">
        <button class="btn btn-success"><i class="fa fa-save"></i> Create Learning Path</button>
      </div>
    </form>
  </div>
</div>

<!-- ACTIVITY MODAL -->
<div class="modal fade" id="activityModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">Add Activities</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal">X</button>
      </div>

      <div class="modal-body">

        <!-- LANGUAGE ONLY (category comes from global selector) -->
        <div class="mb-3" id="languageBlock">
          <label class="form-label"><strong>Language</strong></label>
          <select id="activityLanguageFilter" class="form-control">
            <option value="">All Languages</option>
            <?php foreach ($rawlangs as $code => $v): ?>
              <option value="<?= $code ?>"><?= $langnames[$code] ?? $code ?></option>
            <?php endforeach; ?>
          </select>
        </div>

        <label>Select Items</label>
        <select id="activityCourseSelect" style="width:100%" multiple></select>

      </div>

      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button id="activityAddBtn" class="btn btn-primary">Add to Section</button>
      </div>

    </div>
  </div>
</div>

<script>
window.lp_config = {
  sesskey: '<?= sesskey() ?>',
  ajaxCoursesUrl: '<?= (new moodle_url("/local/learningpath/get_courses2.php"))->out(false) ?>',
  basepath: '<?= (new moodle_url("/local/learningpath/"))->out(false) ?>'
};

$('#lp_name').on('blur', function () {
  let name = $(this).val().trim();
  if (!name) return;
  $.get(window.location.pathname, {
    ajax: 1, name: name, sesskey: '<?= sesskey() ?>'
  }, function (res) {
    $('#lp_name_error').toggleClass('d-none', !res.exists);
  }, 'json');
});
</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-rc.0/js/select2.min.js"></script>

<script src="js/learningpath2.js"></script>

<?php echo $OUTPUT->footer(); ?>
