<?php
require_once('../../config.php');
require_login();

global $DB, $USER;

// -------------------------
// Read submitted data
// -------------------------
$selected_lps     = json_decode(required_param('selected_lps', PARAM_RAW), true);
$selected_batches = json_decode(required_param('selected_batches', PARAM_RAW), true);

$time = time();

// -------------------------
// Load message API for notifications
// -------------------------
require_once($CFG->dirroot . "/message/lib.php");

foreach ($selected_lps as $lpid) {

    foreach ($selected_batches as $cohortid) {

        // ------------------------------------------------------------
        // 1. Insert cohort (batch) into mdl_learning_path_enrolments
        // ------------------------------------------------------------
        $exists = $DB->record_exists('learning_path_enrolments', [
            'learningpathid' => $lpid,
            'cohortid'       => $cohortid
        ]);

        if (!$exists) {
            $record = new stdClass();
            $record->learningpathid = $lpid;
            $record->cohortid       = $cohortid;
            $record->userid         = null;
            $record->enroltype      = 'batch';
            $record->timecreated    = $time;

            $DB->insert_record('learning_path_enrolments', $record);
        }

        // ------------------------------------------------------------
        // 2. Fetch all users from this batch (cohort)
        // ------------------------------------------------------------
        $batchusers = $DB->get_records('cohort_members', [
            'cohortid' => $cohortid
        ]);

        foreach ($batchusers as $bu) {
            $userid = $bu->userid;

            // ----------------------------------------------
            // 2A. Insert each user into mdl_learning_path_enrolments
            // ----------------------------------------------
            $userExists = $DB->record_exists('learning_path_enrolments', [
                'learningpathid' => $lpid,
                'userid'         => $userid
            ]);

            if (!$userExists) {
                $urec = new stdClass();
                $urec->learningpathid = $lpid;
                $urec->userid         = $userid;
                $urec->cohortid       = $cohortid;
                $urec->enroltype      = 'user';
                $urec->timecreated    = $time;

                $DB->insert_record('learning_path_enrolments', $urec);
            }

            // ----------------------------------------------
            // 2B. Insert into mdl_user_enrolments (Moodle enrol)
            // ----------------------------------------------

            // First, find enrol ID for this LP (you may map LP → enrol plugin)
            $enrol = $DB->get_record('enrol', ['courseid' => $lpid], '*', IGNORE_MULTIPLE);

            if ($enrol) {
                $uexists = $DB->record_exists('user_enrolments', [
                    'userid'  => $userid,
                    'enrolid' => $enrol->id
                ]);

                if (!$uexists) {
                    $u = new stdClass();
                    $u->status       = 0;
                    $u->enrolid      = $enrol->id;
                    $u->userid       = $userid;
                    $u->timestart    = $time;
                    $u->timeend      = 2147483647;
                    $u->modifierid   = $USER->id;
                    $u->timecreated  = $time;
                    $u->timemodified = $time;

                    $DB->insert_record('user_enrolments', $u);
                }
            }

            // ----------------------------------------------
            // 2C. Send Notification to User
            // ----------------------------------------------
            $eventdata = new \core\message\message();
            $eventdata->component         = 'moodle';
            $eventdata->name              = 'instantmessage';
            $eventdata->userfrom          = $USER;
            $eventdata->userto            = $userid;
            $eventdata->subject           = "New Learning Path Assigned";
            $eventdata->fullmessage       = "A new Learning Path has been assigned to you.";
            $eventdata->fullmessageformat = FORMAT_MARKDOWN;
            $eventdata->fullmessagehtml   = "<p>A new Learning Path has been assigned to you.</p>";
            $eventdata->smallmessage      = "New Learning Path Assigned";
            $eventdata->notification      = 1;

            message_send($eventdata);
        }
    }
}

// Redirect with success message
redirect(
    new moodle_url('/local/learningpath/admin_learningpath3.php'),
    "Learning Path Assigned Successfully!",
    null,
    \core\output\notification::NOTIFY_SUCCESS
);
