<?php
require('../../config.php');
require_once(__DIR__ . '/local_companycohort_form.php');
require_once($CFG->dirroot . '/cohort/lib.php');
require_once($CFG->libdir . '/csvlib.class.php');

require_login();

$id = required_param('id', PARAM_INT);

$PAGE->set_url('/local/companycohort/edit.php', ['id' => $id]);
$PAGE->set_context(context_system::instance());
$PAGE->set_title('Edit Batch');
$PAGE->set_heading('Edit Batch');

global $DB;

// -----------------------
// FETCH COHORT
// -----------------------
$cohort = $DB->get_record('cohort', ['id' => $id], '*', MUST_EXIST);

// -----------------------
// FETCH EXISTING MEMBERS
// -----------------------
$members = $DB->get_records('cohort_members', ['cohortid' => $id], '', 'id, userid');
$userids = array_column($members, 'userid');
$cohort->selectedusers = implode(',', $userids);

// -----------------------
// INIT FORM
// -----------------------
$form = new local_companycohort_form(null, ['data' => $cohort]);

$errormessage = '';

// -----------------------
// FORM PROCESS
// -----------------------
if ($form->is_cancelled()) {
    redirect(new moodle_url('/cohort/index.php'));

} else if ($data = $form->get_data()) {

    // -----------------------
    // UNIQUE BATCH ID CHECK (EDIT MODE)
    // -----------------------
    $sql = "SELECT id
            FROM {cohort}
            WHERE idnumber = :idnumber
              AND id <> :id";

    $params = [
        'idnumber' => $data->idnumber,
        'id'       => $id
    ];

    if ($DB->record_exists_sql($sql, $params)) {

        // ❌ Duplicate Batch ID
        $errormessage = "Batch ID already exists. Please use a unique ID.";

    } else {

        // -----------------------
        // 1. UPDATE COHORT
        // -----------------------
        $update = new stdClass();
        $update->id = $id;
        $update->name = $data->name;
        $update->idnumber = $data->idnumber;
        $update->company_id = $data->company_id;
        $update->start_date = $data->start_date;
        $update->end_date = $data->end_date;
        $update->timemodified = time();

        $DB->update_record('cohort', $update);

        // -----------------------
        // 2. CSV UPLOAD (EDIT MODE)
        // -----------------------
        if ($data->usermode == 2 && !empty($data->csvfile)) {

            $content = $form->get_file_content('csvfile');

            if ($content) {
                $csvlines = explode(PHP_EOL, $content);
                $rows = array_map('str_getcsv', $csvlines);

                // Header row
                $columns = array_map('trim', array_shift($rows));

                foreach ($rows as $row) {
                    if (empty(array_filter($row))) {
                        continue;
                    }

                    $rowdata = array_combine($columns, $row);

                    $email = trim($rowdata['email']);
                    $firstname = trim($rowdata['firstname']);
                    $lastname = trim($rowdata['lastname']);

                    if (empty($email)) {
                        continue;
                    }

                    if (!$DB->record_exists('user', ['email' => $email])) {
                        $user = new stdClass();
                        $user->auth = 'manual';
                        $user->email = $email;
                        $user->username = $email;
                        $user->firstname = $firstname;
                        $user->lastname = $lastname;
                        $user->password = hash_internal_user_password('Temp@123');
                        $user->confirmed = 1;
                        $user->mnethostid = $CFG->mnet_localhost_id;

                        $userid = $DB->insert_record('user', $user);
                    } else {
                        $userid = $DB->get_field('user', 'id', ['email' => $email]);
                    }

                    if (!$DB->record_exists('cohort_members', ['cohortid' => $id, 'userid' => $userid])) {
                        $cm = new stdClass();
                        $cm->cohortid = $id;
                        $cm->userid = $userid;
                        $cm->timeadded = time();
                        $DB->insert_record('cohort_members', $cm);
                    }
                }
            }
        }

        // -----------------------
        // 3. ADD SELECTED USERS
        // -----------------------
        if (!empty($data->selectedusers)) {
            foreach (explode(',', $data->selectedusers) as $uid) {
                if (!empty($uid) &&
                    !$DB->record_exists('cohort_members', ['cohortid' => $id, 'userid' => $uid])) {

                    $cm = new stdClass();
                    $cm->cohortid = $id;
                    $cm->userid = $uid;
                    $cm->timeadded = time();
                    $DB->insert_record('cohort_members', $cm);
                }
            }
        }

        // ✅ SUCCESS
        redirect(new moodle_url('/cohort/index.php'), 'Updated Successfully', 2);
    }
}

// -----------------------
// DISPLAY PAGE
// -----------------------
echo $OUTPUT->header();

if (!empty($errormessage)) {
    echo html_writer::div($errormessage, 'alert alert-danger');
}

$form->display();
echo $OUTPUT->footer();
