<?php
require_once(__DIR__ . '/../config.php');
require_login();

global $DB, $OUTPUT, $PAGE;

$context = context_system::instance();
$PAGE->set_context($context);
$PAGE->set_url(new moodle_url('/course/wcompanylist.php'));
$PAGE->set_title('Company List');
$PAGE->set_heading('Company List');

// Handle delete
$deleteid = optional_param('delete', 0, PARAM_INT);
if ($deleteid) {
    require_sesskey();
    $DB->delete_records('company', ['id' => $deleteid]);
    redirect(new moodle_url('/course/wcompanylist.php'), 'Company deleted successfully.', 1);
}

// Header
echo $OUTPUT->header();

// Top Card Header with Add Button
echo html_writer::start_div('card shadow-sm mb-3');
echo html_writer::start_div('card-header d-flex justify-content-between align-items-center');
echo html_writer::tag('h3', 'Manage Companies', ['class' => 'm-0']);
echo html_writer::link(
    new moodle_url('/course/wcompany.php'),
    'Add Company',
    ['class' => 'btn btn-primary']
);
echo html_writer::end_div(); // card-header

// Card Body for Table
echo html_writer::start_div('card-body');

// Create table HTML
echo '<table id="companyTable" class="table table-striped table-bordered" style="width:100%">';
echo '<thead>
        <tr>
            <th>S.No</th>
            <th>Company</th>
            <th>Email</th>
            <th>Date</th>
            <th>Actions</th>
        </tr>
      </thead>';
echo '<tbody>';

// Fetch companies
$companies = $DB->get_records('company', null, 'id DESC');
$i = 1;
foreach ($companies as $company) {
    $editurl = new moodle_url('/course/wcompany.php', ['id' => $company->id]);
    $deleteurl = new moodle_url('/course/wcompanylist.php', [
        'delete'  => $company->id,
        'sesskey' => sesskey()
    ]);

   // Get company email
$companyemail = !empty($company->email) ? $company->email : 'N/A';


    // Moodle standard icons
    $editicon = $OUTPUT->action_icon($editurl, new pix_icon('t/edit', get_string('edit')));
  $confirmmsg = ' Confirm delete: ' . format_string($company->com_name);

$deleteicon = $OUTPUT->action_icon(
    $deleteurl,
    new pix_icon('t/delete', get_string('delete')),
    new confirm_action($confirmmsg)
);


    echo '<tr>';
    echo '<td>' . $i++ . '</td>';
    echo '<td>' . format_string($company->com_name) . '</td>';
    echo '<td>' . format_string($companyemail) . '</td>';
    echo '<td>' . userdate(strtotime($company->created_at), get_string('strftimedate')) . '</td>';
    echo '<td>' . $editicon . ' ' . $deleteicon . '</td>';
    echo '</tr>';
}

echo '</tbody>';
echo '</table>';
echo html_writer::end_div(); // card-body
echo html_writer::end_div(); // card

// Include DataTables JS & CSS
?>
<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

<script>
$(document).ready(function() {
    $('#companyTable').DataTable({
        "pageLength": 10,
        "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
        "ordering": true,
        "responsive": true
    });
});
</script>
<?php
echo $OUTPUT->footer();
