<?php
require('../config.php');
require_login();
global $DB, $OUTPUT, $PAGE;

// -------------------------------------------------------
// Get cohort ID
// -------------------------------------------------------
$cohortid = required_param('id', PARAM_INT);
$page     = optional_param('page', 0, PARAM_INT); // NEW
$perpage  = 20; // Moodle default size

// Check cohort exists
$cohort = $DB->get_record('cohort', ['id' => $cohortid], '*', MUST_EXIST);

// Permission check
$context = context_system::instance();
require_capability('moodle/cohort:view', $context);

// Page settings
$PAGE->set_url(new moodle_url('/cohort/users.php', ['id' => $cohortid, 'page' => $page]));
$PAGE->set_context($context);
$PAGE->set_title("Cohort Users: " . $cohort->name);
$PAGE->set_heading("Users in Cohort: " . $cohort->name);

// -------------------------------------------------------
// Get TOTAL user count
// -------------------------------------------------------
$countsql = "SELECT COUNT(*)
             FROM {cohort_members}
             WHERE cohortid = :cohortid";

$totalusers = $DB->count_records_sql($countsql, ['cohortid' => $cohortid]);

// -------------------------------------------------------
// Fetch paginated users
// -------------------------------------------------------
$sql = "SELECT u.id, u.firstname, u.lastname, u.email
        FROM {cohort_members} cm
        JOIN {user} u ON u.id = cm.userid
        WHERE cm.cohortid = :cohortid
        ORDER BY u.firstname ASC";

$users = $DB->get_records_sql($sql, ['cohortid' => $cohortid], $page * $perpage, $perpage);

// Output page
echo $OUTPUT->header();

echo html_writer::tag('h3', "Users in Batch: {$cohort->name}");

// -------------------------------------------------------
// Show paging bar
// -------------------------------------------------------
echo $OUTPUT->paging_bar($totalusers, $page, $perpage, $PAGE->url);

// -------------------------------------------------------
// Build table
// -------------------------------------------------------
$table = new html_table();
$table->head = ['S.No', 'First Name', 'Last Name', 'Email'];
$table->attributes['class'] = 'generaltable';

$rows = [];
$srno = $page * $perpage + 1; // serial number with pagination

foreach ($users as $u) {
    $rows[] = new html_table_row([
        $srno++,
        format_string($u->firstname),
        format_string($u->lastname),
        html_writer::link("mailto:$u->email", $u->email)
    ]);
}

$table->data = $rows;

// Display table
echo html_writer::table($table);

// Show paging bar again (optional)
echo $OUTPUT->paging_bar($totalusers, $page, $perpage, $PAGE->url);

echo $OUTPUT->footer();
